/*
 * Decompiled with CFR 0.152.
 */
package scheduleData;

import java.text.DecimalFormat;
import scheduleData.DateInfo;

public class ScheduleData
implements Cloneable {
    private String title = "";
    private DateInfo s_date = new DateInfo();
    private DateInfo e_date;
    private String place = "";
    private String projectUnitName = "";
    private String prj_code = "";
    private String projectName = "";
    private String selectedPhaseFilter = "";
    private String selectedAssignment = "";
    private String phaseName = "";
    private String wbsNo = "";
    private String work = "";
    private String comment = "";
    private String eventCode = "";
    private int colorInfo;
    private boolean closed;
    private boolean unFixed;
    private int progressRatio;
    private int uniquieId;
    private String cNum = "";
    private String updatePerson = "";

    public ScheduleData() {
        this.s_date.clear();
        this.e_date = new DateInfo();
        this.e_date.clear();
    }

    public Object clone() {
        ScheduleData sd = new ScheduleData();
        sd.title = new String(this.title);
        sd.place = new String(this.place);
        sd.projectUnitName = new String(this.projectUnitName);
        sd.prj_code = new String(this.prj_code);
        sd.setProjectName(new String(this.projectName));
        sd.setSelectedPhaseFilter(new String(this.selectedPhaseFilter));
        sd.setSelectedAssignment(new String(this.selectedAssignment));
        sd.comment = new String(this.comment);
        sd.phaseName = new String(this.phaseName);
        sd.work = new String(this.work);
        sd.s_date = (DateInfo)this.s_date.clone();
        sd.e_date = (DateInfo)this.e_date.clone();
        sd.colorInfo = this.colorInfo;
        sd.closed = this.closed;
        sd.unFixed = this.unFixed;
        sd.setUniquieId(this.uniquieId);
        sd.setWbsNo(new String(this.wbsNo));
        sd.setCNum(new String(this.cNum));
        return sd;
    }

    public boolean compare2(ScheduleData sd) {
        return this.compare(sd) && sd.isClosed() == this.isClosed();
    }

    public boolean compare(ScheduleData sd) {
        return this.s_date.compare(sd.s_date) && this.e_date.compare(sd.e_date) && this.title.equals(sd.title) && this.place.equals(sd.place);
    }

    public String createScheduleDataKey() {
        String str = String.valueOf(this.s_date.createDateInfoKey()) + this.e_date.createDateInfoKey() + this.title + this.place;
        return str;
    }

    public ScheduleData createSchedule4DoubleClick() {
        ScheduleData sd = new ScheduleData();
        sd.s_date.setHH("00");
        sd.s_date.setMM("00");
        sd.e_date.setHH("01");
        sd.e_date.setMm("00");
        return sd;
    }

    public boolean isWorkInfoEmpty() {
        return this.projectUnitName.length() < 1 || this.prj_code.length() < 1 || this.phaseName.length() < 1 || this.work.length() < 1;
    }

    public boolean compare4Atmuo(String prjCode, String faseName, String workName) {
        return this.prj_code.equals(prjCode) && faseName.equals(faseName) && workName.equals(workName);
    }

    public int getTimeHour() {
        int result = 0;
        result = Integer.valueOf(this.s_date.getMM()) <= Integer.valueOf(this.e_date.getMM()) ? Integer.valueOf(this.e_date.getHH()) - Integer.valueOf(this.s_date.getHH()) : Integer.valueOf(this.e_date.getHH()) - Integer.valueOf(this.s_date.getHH()) - 1;
        if (result >= 0) {
            return result;
        }
        return 0;
    }

    public int getTimeMinute() {
        int result = 0;
        result = Integer.valueOf(this.s_date.getMM()) <= Integer.valueOf(this.e_date.getMM()) ? Integer.valueOf(this.e_date.getMM()) - Integer.valueOf(this.s_date.getMM()) : Integer.valueOf(this.e_date.getMM()) + 60 - Integer.valueOf(this.s_date.getMM());
        return result;
    }

    public double getTimeByHour() {
        double startTime = Integer.valueOf(this.s_date.getMM()) + Integer.valueOf(this.s_date.getHH()) * 60;
        double endTime = Integer.valueOf(this.e_date.getMM()) + Integer.valueOf(this.e_date.getHH()) * 60;
        double result = (endTime - startTime) / 60.0;
        return result;
    }

    public String getTimeByHourString() {
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(this.getTimeByHour());
    }

    public int getTimeByMinute() {
        int result = 0;
        result = Integer.valueOf(this.s_date.getHH()) <= Integer.valueOf(this.e_date.getHH()) ? (Integer.valueOf(this.e_date.getHH()) - Integer.valueOf(this.s_date.getHH())) * 60 : 0;
        result = Integer.valueOf(this.s_date.getMM()) <= Integer.valueOf(this.e_date.getMM()) ? (result += Integer.valueOf(this.e_date.getMM()) - Integer.valueOf(this.s_date.getMM())) : (result += Integer.valueOf(this.e_date.getMM()) + 60 - Integer.valueOf(this.s_date.getMM()) - 60);
        return result;
    }

    public void setEndDateFromTimeMinute(int timeMinute) {
        int wHH = timeMinute / 60;
        int wMM = timeMinute % 60;
        DateInfo di = new DateInfo();
        di.setYyyy(this.getE_date().getYyyy());
        di.setMm(this.getE_date().getMm());
        di.setDd(this.getE_date().getDd());
        di.setHH(this.getS_date().getHH());
        di.addHH(Integer.toString(wHH));
        di.setMM(this.getS_date().getMM());
        di.addMM(Integer.toString(wMM));
        this.setE_date(di);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DateInfo getS_date() {
        return this.s_date;
    }

    public void setS_date(DateInfo s_date) {
        this.s_date = s_date;
    }

    public DateInfo getE_date() {
        return this.e_date;
    }

    public void setE_date(DateInfo e_date) {
        if (this.getS_date().getYyyy().equals(e_date.getYyyy()) && this.getS_date().getMm().equals(e_date.getMm()) && this.getS_date().getDd().equals(e_date.getDd())) {
            if (this.getS_date().compareDateInfo(e_date) != -1) {
                System.err.println("caution, EndDate is smaller than StartDate." + this.getS_date().createDateInfoKey() + "," + e_date.createDateInfoKey() + "," + this.getTitle());
                DateInfo di = (DateInfo)this.getS_date().clone();
                di.increment30minWithRoundUp();
                this.e_date = di;
            } else {
                this.e_date = e_date;
            }
        } else {
            System.err.println("caution, EndDate'yyymmdd isn't same as StartDate." + this.getS_date().createDateInfoKey() + "," + e_date.createDateInfoKey() + "," + this.getTitle());
            DateInfo di = (DateInfo)this.getS_date().clone();
            di.increment30minWithRoundUp();
            this.e_date = di;
        }
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getProjectUnitName() {
        return this.projectUnitName;
    }

    public void setProjectUnitName(String projectUnitName) {
        this.projectUnitName = projectUnitName;
    }

    public String getPrj_code() {
        return this.prj_code;
    }

    public void setPrj_code(String prj_code) {
        this.prj_code = prj_code;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getSelectedPhaseFilter() {
        return this.selectedPhaseFilter;
    }

    public void setSelectedPhaseFilter(String selectedPhaseFilter) {
        this.selectedPhaseFilter = selectedPhaseFilter;
    }

    public String getSelectedAssignment() {
        return this.selectedAssignment;
    }

    public void setSelectedAssignment(String selectedAssignment) {
        this.selectedAssignment = selectedAssignment;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phase) {
        this.phaseName = phase;
    }

    public String getWbsNo() {
        return this.wbsNo;
    }

    public void setWbsNo(String wbsNo) {
        this.wbsNo = wbsNo;
    }

    public String getWork() {
        return this.work;
    }

    public void setWork(String work) {
        this.work = work;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    public int getColorInfo() {
        return this.colorInfo;
    }

    public void setColorInfo(int colorInfo) {
        this.colorInfo = colorInfo;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isUnFixed() {
        return this.unFixed;
    }

    public void setUnFixed(boolean unFixed) {
        this.unFixed = unFixed;
    }

    public int getProgressRatio() {
        return this.progressRatio;
    }

    public void setProgressRatio(int progressRatio) {
        this.progressRatio = progressRatio;
    }

    public void setProgressRatio(String progressRatioStr) {
        if (progressRatioStr.isEmpty()) {
            this.setProgressRatio(0);
            return;
        }
        try {
            int value = Integer.valueOf(progressRatioStr);
            this.setProgressRatio(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.err.println(String.valueOf(this.getClass().getName()) + ".setProgressRatio \"" + progressRatioStr + "\"");
            this.setProgressRatio(0);
        }
    }

    public int getUniquieId() {
        return this.uniquieId;
    }

    public void setUniquieId(int uniquieId) {
        this.uniquieId = uniquieId;
    }

    public String getCNum() {
        return this.cNum;
    }

    public void setCNum(String num) {
        this.cNum = num;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public boolean checkOverlap(ScheduleData targetSd) {
        if (!this.s_date.isSameDay(targetSd.getS_date())) {
            return false;
        }
        if (this.s_date.compare(targetSd.getE_date())) {
            return false;
        }
        if (this.e_date.compare(targetSd.getS_date())) {
            return false;
        }
        if (this.s_date.compareDateInfo3(targetSd.getE_date()) == 1) {
            return false;
        }
        return this.e_date.compareDateInfo3(targetSd.getS_date()) != -1;
    }

    public void convertProjectCode(String beforeCode, String afterCode) {
        if (this.getPrj_code().equals(beforeCode)) {
            this.setPrj_code(afterCode);
        }
    }
}

