/*
 * Decompiled with CFR 0.152.
 */
package uiDetailSchedule;

import commonData.UserInfo;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JDialog;
import scheduleData.ScheduleData;
import uiCommon.UiJButtonListener;
import uiDetailSchedule.DetailScheduleFrameAdapter;
import uiDetailSchedule.DetailScheduleListener;
import uiDetailSchedule.DetailSchedulePanel1;
import uiDetailSchedule.DetailSchedulePanel2;
import uiDetailSchedule.DetailSchedulePanel3;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectCodeList;
import workMasterData.WorkInfoListMap;

public class DetailScheduleJDialog
extends JDialog
implements UiJButtonListener {
    static final long serialVersionUID = 0L;
    private String title;
    private DetailScheduleListener dspl;
    private ScheduleData sd;
    private UserInfo userInfo;
    protected ProjectCodeList projectCodeList;
    protected PhaseInfoListMap phaseInfoListMap;
    protected WorkInfoListMap workInfoListMap;
    private DetailSchedulePanel1 dsp1;
    private DetailSchedulePanel2 dsp2;
    private DetailSchedulePanel3 dsp3;
    private static String buttonUpdate = "\u66f4\u65b0";
    private static String buttonDel = "\u524a\u9664";
    private static String buttonGet = "\u53d6\u8fbc";

    public DetailScheduleJDialog(Frame frame, String title, int x, int y, ScheduleData sd, UserInfo userInfo, DetailScheduleListener dspl, ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        super(frame);
        this.title = title;
        this.dspl = dspl;
        this.sd = sd;
        this.userInfo = userInfo;
        this.projectCodeList = projectCodeList;
        this.phaseInfoListMap = phaseInfoListMap;
        this.workInfoListMap = workInfoListMap;
        this.initDetailScheduleJDialog(title, x, y, 300, 300, sd, userInfo, projectCodeList, phaseInfoListMap, workInfoListMap);
    }

    @Override
    public void uiJButtonClicked(String buttonName) {
        if (buttonName.equals(buttonUpdate)) {
            this.dspl.detailNotifyAddScheduleClicked(this.getNowScheduleData(), this.userInfo);
        } else if (buttonName.equals(buttonDel)) {
            this.dspl.detailNotifyDelScheduleClicked();
        } else if (buttonName.equals(buttonGet)) {
            this.dspl.detailNotifyGetScheduleClicked(this.sd, this.userInfo);
        }
    }

    private void initDetailScheduleJDialog(String title, int x, int y, int frameWidth, int frameHeight, ScheduleData sd, UserInfo userInfo, ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        this.setLayout(null);
        this.addPanel(sd, userInfo, frameWidth, projectCodeList, phaseInfoListMap, workInfoListMap);
        this.setBounds(x, y, frameWidth, frameHeight);
        this.setTitle(title);
        this.setResizable(false);
        this.setMinimumSize(new Dimension(242, 380));
        DetailScheduleFrameAdapter dsfa = new DetailScheduleFrameAdapter(this);
        this.addComponentListener(dsfa);
        this.setVisible(true);
    }

    public void notifyResize(int x, int y, int frameWidth, int frameHeight) {
        this.initDetailScheduleJDialog(this.title, x, y, frameWidth, frameHeight, this.sd, this.userInfo, this.projectCodeList, this.phaseInfoListMap, this.workInfoListMap);
    }

    public void addPanel(ScheduleData sd, UserInfo userInfo) {
        this.sd = sd;
        this.userInfo = userInfo;
        this.addPanel(sd, userInfo, 300, this.projectCodeList, this.phaseInfoListMap, this.workInfoListMap);
    }

    public void addPanel(ScheduleData sd, UserInfo userInfo, int frameWidth, ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        boolean editAble = false;
        if (sd == null) {
            editAble = false;
            sd = new ScheduleData();
        } else if (userInfo != null) {
            editAble = userInfo.getEditMode();
        }
        if (projectCodeList == null) {
            projectCodeList = new ProjectCodeList();
        }
        if (phaseInfoListMap == null) {
            phaseInfoListMap = new PhaseInfoListMap();
        }
        if (workInfoListMap == null) {
            workInfoListMap = new WorkInfoListMap();
        }
        if (this.dsp1 != null) {
            this.remove(this.dsp1);
        }
        ArrayList<String> buttonList = new ArrayList<String>();
        buttonList.add(buttonUpdate);
        buttonList.add(buttonDel);
        buttonList.add(buttonGet);
        this.dsp1 = new DetailSchedulePanel1(buttonList, this, editAble);
        this.dsp1.setBounds(this.calcRectanglePanel1(frameWidth));
        this.add(this.dsp1);
        if (this.dsp2 != null) {
            this.remove(this.dsp2);
        }
        this.dsp2 = new DetailSchedulePanel2(this.dspl, frameWidth, editAble, sd, projectCodeList, phaseInfoListMap, workInfoListMap);
        this.dsp2.setBounds(this.calcRectanglePanel2(frameWidth, this.dsp2.getPanel2Height()));
        this.add(this.dsp2);
        if (this.dsp3 != null) {
            this.remove(this.dsp3);
        }
        this.dsp3 = new DetailSchedulePanel3(frameWidth, editAble, sd.closed, sd.isUnFixed(), sd.getProgressRatio(), sd.colorInfo, sd.comment);
        this.dsp3.setBounds(this.calcRectanglePanel3(frameWidth, this.dsp3.getPreferredSize().height));
        this.add(this.dsp3);
        this.validate();
        this.repaint();
    }

    public void reqestRemoveNotify() {
        this.removeNotify();
    }

    public ScheduleData getScheduleData() {
        return this.sd;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    private ScheduleData getNowScheduleData() {
        ScheduleData sd = this.dsp2.getScheduleData();
        sd.closed = this.dsp3.getClosedCheckBox();
        sd.setUnFixed(this.dsp3.isUnFixed());
        sd.colorInfo = this.dsp3.getColorInfo();
        sd.setProgressRatio(this.dsp3.getProgressRatioStr());
        sd.comment = this.dsp3.getComment();
        return sd;
    }

    private Rectangle calcRectanglePanel1(int frameWidth) {
        return new Rectangle(0, 0, this.calcWidth(frameWidth) - 6, 22);
    }

    private Rectangle calcRectanglePanel2(int frameWidth, int panel2Height) {
        return new Rectangle(0, 22, this.calcWidth(frameWidth), panel2Height);
    }

    private Rectangle calcRectanglePanel3(int frameWidth, int panel3Height) {
        return new Rectangle(0, this.dsp1.getHeight() + this.dsp2.getHeight(), this.calcWidth(frameWidth), panel3Height);
    }

    private int calcWidth(int frameWidth) {
        int width = frameWidth < 300 ? 300 : frameWidth;
        return width;
    }
}

