/*
 * Decompiled with CFR 0.152.
 */
package uiDetailSchedule;

import commonData.UserInfo;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import scheduleData.NotesScheduleData;
import scheduleData.ScheduleData;
import uiCommon.UiJButtonListener;
import uiDetailSchedule.DetailScheduleListener;
import uiDetailSchedule.DetailSchedulePanel5;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectUnitList;
import workMasterData.WorkInfoListMap;

public class DetailScheduleJDialog2
extends JDialog
implements UiJButtonListener,
ComponentListener,
WindowListener {
    static final long serialVersionUID = 0L;
    private DetailScheduleListener dspl;
    private ScheduleData sd;
    private UserInfo userInfo;
    private UserInfo currentUserInfo;
    protected ProjectUnitList projectUnitList;
    protected PhaseInfoListMap phaseInfoListMap;
    protected WorkInfoListMap workInfoListMap;
    private DetailSchedulePanel5 dsp;
    private static String buttonUpdate = "\u66f4\u65b0";
    private static String buttonDel = "\u524a\u9664";
    private static String button2Clipboard = "\u30af\u30ea\u30c3\u30d7";
    private static String buttonGet = "\u53d6\u8fbc";

    public DetailScheduleJDialog2(Frame frame, String title, Point point, Dimension dimension, ScheduleData sd, UserInfo userInfo, DetailScheduleListener dspl, ProjectUnitList projectUnitList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap, UserInfo currentUserInfo) {
        super(frame);
        this.dspl = dspl;
        this.sd = sd;
        this.userInfo = userInfo;
        this.projectUnitList = projectUnitList;
        this.phaseInfoListMap = phaseInfoListMap;
        this.workInfoListMap = workInfoListMap;
        this.currentUserInfo = currentUserInfo;
        this.initDetailScheduleJDialog(title, point.x, point.y, dimension.width, dimension.height, sd, userInfo, projectUnitList, phaseInfoListMap, workInfoListMap, currentUserInfo);
        this.addComponentListener(this);
        this.addWindowListener(this);
    }

    @Override
    public void uiJButtonClicked(String buttonName) {
        if (buttonName.equals(buttonUpdate)) {
            this.dspl.detailNotifyAddScheduleClicked(this.getNowScheduleData(), this.userInfo);
        } else if (buttonName.equals(buttonDel)) {
            this.dspl.detailNotifyDelScheduleClicked();
        } else if (buttonName.equals(button2Clipboard)) {
            this.dspl.detailNotifyToClipboardClicked(this.sd);
        } else if (buttonName.equals(buttonGet)) {
            this.dspl.detailNotifyGetScheduleClicked(this.getNowScheduleData(), this.userInfo);
        }
    }

    private void initDetailScheduleJDialog(String title, int x, int y, int frameWidth, int frameHeight, ScheduleData sd, UserInfo userInfo, ProjectUnitList projectUnitList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap, UserInfo currentUserInfo) {
        this.addPanel(sd, userInfo, frameWidth, projectUnitList, phaseInfoListMap, workInfoListMap, currentUserInfo);
        this.setBounds(x, y, frameWidth, frameHeight);
        this.setTitle(title);
        this.setPreferredSize(new Dimension(frameWidth, frameHeight));
        this.setVisible(true);
    }

    public void addPanel(ScheduleData sd, UserInfo userInfo, UserInfo currentUserInfo) {
        this.sd = sd;
        this.userInfo = userInfo;
        this.addPanel(sd, userInfo, 300, this.projectUnitList, this.phaseInfoListMap, this.workInfoListMap, currentUserInfo);
    }

    public void addPanel(ScheduleData sd, UserInfo userInfo, int frameWidth, ProjectUnitList projectUnitList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap, UserInfo currentUserInfo) {
        boolean editAble = false;
        boolean importAble = false;
        if (sd == null) {
            editAble = false;
            sd = new ScheduleData();
        } else if (userInfo != null) {
            editAble = userInfo.getEditMode();
            importAble = userInfo.isImportMode();
        }
        if (this.dsp != null) {
            this.remove(this.dsp);
        }
        if (!(sd instanceof NotesScheduleData)) {
            if (this.projectUnitList == null) {
                this.projectUnitList = new ProjectUnitList();
            }
            if (this.phaseInfoListMap == null) {
                this.phaseInfoListMap = new PhaseInfoListMap();
            }
            if (this.workInfoListMap == null) {
                this.workInfoListMap = new WorkInfoListMap();
            }
            this.dsp = userInfo != null && sd != null && !userInfo.isSame(currentUserInfo) && sd.isClosed() ? new DetailSchedulePanel5(this, editAble, importAble, sd, projectUnitList, phaseInfoListMap, workInfoListMap, true) : new DetailSchedulePanel5(this, editAble, importAble, sd, projectUnitList, phaseInfoListMap, workInfoListMap, false);
        }
        this.add(this.dsp);
        this.validate();
        this.repaint();
    }

    public void reqestRemoveNotify() {
        this.removeNotify();
    }

    public ScheduleData getScheduleData() {
        return this.sd;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    private ScheduleData getNowScheduleData() {
        ScheduleData sd = this.dsp.getScheduleData();
        return sd;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.dspl.detailNotifyComponentMoved(this.getLocation());
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.dspl.detailNotifyComponentResyzed(this.getSize());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dspl.detailNotifyComponentClosed();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

