/*
 * Decompiled with CFR 0.152.
 */
package uiDetailSchedule;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JPanel;
import scheduleData.ScheduleData;
import uiDetailSchedule.DetailScheduleListener;
import uiDetailSchedule.ItemDateInfo;
import uiDetailSchedule.ItemInfo;
import uiDetailSchedule.ItemInfo2;
import uiDetailSchedule.ItemInfo2Listener;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectCodeList;
import workMasterData.WorkInfoListMap;

public class DetailSchedulePanel2
extends JPanel
implements ItemInfo2Listener {
    static final long serialVersionUID = 0L;
    private DetailScheduleListener dspl;
    private ScheduleData sd;
    private int frameWidth;
    private boolean editAble;
    private ProjectCodeList projectCodeList;
    private PhaseInfoListMap phaseInfoListMap;
    private WorkInfoListMap workInfoListMap;
    private ItemInfo title;
    private ItemInfo place;
    private ItemDateInfo startDateInfo;
    private ItemDateInfo endDateInfo;
    private ItemInfo2 projectCode;
    private ItemInfo2 phaseName;
    private ItemInfo2 workName;
    private static final int minWidth = 240;
    private static final int oneHeight = 24;

    public DetailSchedulePanel2(DetailScheduleListener dspl, int frameWidth, boolean editAble) {
        this.dspl = dspl;
        this.initDetailSchedulePanel(new ScheduleData(), frameWidth, editAble, null, null, null);
    }

    public DetailSchedulePanel2(DetailScheduleListener dspl, int frameWidth, boolean editAble, ScheduleData sd, ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        this.dspl = dspl;
        this.initDetailSchedulePanel(sd, frameWidth, editAble, projectCodeList, phaseInfoListMap, workInfoListMap);
    }

    private void initDetailSchedulePanel(ScheduleData sd, int frameWidth, boolean editAble, ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        this.setLayout(null);
        this.sd = sd;
        this.frameWidth = frameWidth;
        this.editAble = editAble;
        this.projectCodeList = projectCodeList;
        this.phaseInfoListMap = phaseInfoListMap;
        this.workInfoListMap = workInfoListMap;
        this.title = new ItemInfo("\u8868\u984c", frameWidth, editAble, sd.title);
        this.title.setPreferredSize(new Dimension(frameWidth, 22));
        this.place = new ItemInfo("\u5834\u6240", frameWidth, editAble, sd.place);
        this.place.setPreferredSize(new Dimension(frameWidth, 22));
        this.startDateInfo = new ItemDateInfo("\u958b\u59cb", editAble, sd.getS_date());
        this.startDateInfo.setPreferredSize(new Dimension(frameWidth, 22));
        this.endDateInfo = new ItemDateInfo("\u7d42\u4e86", editAble, sd.getE_date());
        this.endDateInfo.setPreferredSize(new Dimension(frameWidth, 22));
        this.projectCode = new ItemInfo2(this, "PRJ", frameWidth, editAble, projectCodeList.getProjectCodeName(sd.prj_code), projectCodeList.getAllProjectCodeNameList());
        this.projectCode.setPreferredSize(new Dimension(frameWidth, 22));
        this.phaseName = this.makeItemInfo2Panel(this, "\u5de5\u7a0b", frameWidth, editAble, sd.getPhaseName(), this.makePhaseNameList(projectCodeList, phaseInfoListMap, sd.prj_code));
        this.phaseName.setPreferredSize(new Dimension(frameWidth, 22));
        this.workName = this.makeItemInfo2Panel(this, "\u4f5c\u696d", frameWidth, editAble, sd.work, this.makeWorkNameList(projectCodeList, workInfoListMap, sd.prj_code));
        this.workName.setPreferredSize(new Dimension(frameWidth, 22));
        this.setPreferredSize(this.calcDimension());
        this.add(this.title);
        this.add(this.place);
        this.add(this.startDateInfo);
        this.add(this.endDateInfo);
        this.add(this.projectCode);
        this.add(this.phaseName);
        this.add(this.workName);
    }

    @Override
    public void notifyComboBoxChanged(String title, String selectedProjectCodeName) {
        if (title.equals("PRJ")) {
            String selectedProjectCode = this.extractProjectCode(selectedProjectCodeName);
            if (this.phaseName != null) {
                this.remove(this.phaseName);
            }
            String wkPhase = this.phaseName.getSelectedValue();
            this.phaseName = this.makeItemInfo2Panel(this, "\u5de5\u7a0b", this.frameWidth, this.editAble, wkPhase, this.makePhaseNameList(this.projectCodeList, this.phaseInfoListMap, selectedProjectCode));
            this.phaseName.setPreferredSize(new Dimension(this.frameWidth, 22));
            if (this.workName != null) {
                this.remove(this.workName);
            }
            String wkWork = this.workName.getSelectedValue();
            this.workName = this.makeItemInfo2Panel(this, "\u4f5c\u696d", this.frameWidth, this.editAble, wkWork, this.makeWorkNameList(this.projectCodeList, this.workInfoListMap, selectedProjectCode));
            this.workName.setPreferredSize(new Dimension(this.frameWidth, 22));
            this.setPreferredSize(this.calcDimension());
            this.add(this.phaseName);
            this.add(this.workName);
            this.validate();
            this.repaint();
        }
    }

    private String extractProjectCode(String projectCodeName) {
        String[] wkStr = projectCodeName.split(" ");
        return wkStr[0];
    }

    private ArrayList<String> makePhaseNameList(ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, String projectCode) {
        ArrayList<String> result = new ArrayList<String>();
        for (String phaseListFileName : projectCodeList.getPhaseNameFileList(projectCode)) {
            if (phaseInfoListMap.getPhaseInfoList(phaseListFileName) == null) continue;
            result.addAll(phaseInfoListMap.getPhaseInfoList(phaseListFileName).getAllPhaseNameList());
        }
        return result;
    }

    private ArrayList<String> makeWorkNameList(ProjectCodeList projectCodeList, WorkInfoListMap workInfoListMap, String projectCode) {
        ArrayList<String> result = new ArrayList<String>();
        for (String workListFileName : projectCodeList.getWorkNameFileList(projectCode)) {
            if (workInfoListMap.getWorkInfoList(workListFileName) == null) continue;
            result.addAll(workInfoListMap.getWorkInfoList(workListFileName).getAllNameList());
        }
        return result;
    }

    private ItemInfo2 makeItemInfo2Panel(ItemInfo2Listener ii2l, String title, int frameWidth, boolean editAble, String selectedValue, ArrayList<String> valueList) {
        return new ItemInfo2(ii2l, title, frameWidth, editAble, selectedValue, valueList);
    }

    public Dimension calcDimension() {
        int maxWidth = 0;
        this.title.setBounds(0, 0, this.title.getPreferredSize().width, this.title.getPreferredSize().height);
        if (this.title.getPreferredSize().width > maxWidth) {
            maxWidth = this.title.getPreferredSize().width;
        }
        int beforeHeight = this.title.getHeight();
        this.place.setBounds(0, beforeHeight, this.place.getPreferredSize().width, this.place.getPreferredSize().height);
        if (this.place.getPreferredSize().width > maxWidth) {
            maxWidth = this.place.getPreferredSize().width;
        }
        this.startDateInfo.setBounds(0, (beforeHeight += this.place.getHeight()) + 2, this.startDateInfo.getPreferredSize().width, this.startDateInfo.getPreferredSize().height);
        if (this.startDateInfo.getPreferredSize().width > maxWidth) {
            maxWidth = this.startDateInfo.getPreferredSize().width;
        }
        this.endDateInfo.setBounds(0, beforeHeight += this.startDateInfo.getHeight() + 2, this.endDateInfo.getPreferredSize().width, this.endDateInfo.getPreferredSize().height);
        this.projectCode.setBounds(0, (beforeHeight += this.endDateInfo.getHeight()) + 2, this.projectCode.getPreferredSize().width, this.projectCode.getPreferredSize().height);
        if (this.projectCode.getPreferredSize().width > maxWidth) {
            maxWidth = this.projectCode.getPreferredSize().width;
        }
        this.phaseName.setBounds(0, beforeHeight += this.projectCode.getHeight() + 2, this.phaseName.getPreferredSize().width, this.phaseName.getPreferredSize().height);
        if (this.phaseName.getPreferredSize().width > maxWidth) {
            maxWidth = this.phaseName.getPreferredSize().width;
        }
        this.workName.setBounds(0, beforeHeight += this.phaseName.getHeight(), this.workName.getPreferredSize().width, this.workName.getPreferredSize().height);
        if (this.workName.getPreferredSize().width > maxWidth) {
            maxWidth = this.workName.getPreferredSize().width;
        }
        return new Dimension(maxWidth, beforeHeight += this.workName.getHeight());
    }

    public ScheduleData getScheduleData() {
        ScheduleData sd = new ScheduleData();
        sd.title = this.title.getValue();
        sd.place = this.place.getValue();
        sd.setS_date(this.startDateInfo.getDateInfo());
        sd.setE_date(this.endDateInfo.getDateInfo());
        sd.prj_code = this.extractProjectCode(this.projectCode.getSelectedValue());
        sd.setPhaseName(this.phaseName.getSelectedValue());
        sd.work = this.workName.getSelectedValue();
        return sd;
    }

    public int getPanel2Height() {
        return this.getPreferredSize().height;
    }

    public void setResyse(int frameWidth) {
        this.projectCode.setResyse(frameWidth);
        this.phaseName.setResyse(frameWidth);
        this.workName.setResyse(frameWidth);
        this.setPreferredSize(this.calcDimension());
        this.validate();
        this.repaint();
    }

    private int calcWidth(int frameWidth) {
        if (frameWidth < 300) {
            return 298;
        }
        return frameWidth - 2;
    }
}

