/*
 * Decompiled with CFR 0.152.
 */
package uiDetailSchedule;

import commonData.CommonStatic;
import commonData.LimitedNumeralDocument;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import uiCommon.UiJButton;
import uiCommon.UiJButtonListener;
import uiCommon.UiJLabel;
import uiCommon.UiJTextField;
import uiDetailSchedule.DetailScheduleJComboBox;
import uiDetailSchedule.DetailScheduleJComboBoxListener;
import uiDetailSchedule.DetailStatic;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectCodeList;
import workMasterData.WorkInfoListMap;

public class DetailSchedulePanel4
extends JPanel
implements ActionListener,
DetailScheduleJComboBoxListener {
    static final long serialVersionUID = 0L;
    private UiJButton updateButton;
    private UiJButton deleteButton;
    private UiJButton importButton;
    private UiJLabel titleLabel;
    private UiJTextField title;
    private UiJLabel placeLabel;
    private UiJTextField place;
    private UiJLabel startLabel;
    private UiJTextField startYyyy;
    private UiJLabel startYyyyLabel;
    private UiJTextField startMm;
    private UiJLabel startMmLabel;
    private UiJTextField startDd;
    private UiJLabel startDdLabel;
    private UiJTextField startHH;
    private UiJLabel startHHLabel;
    private UiJTextField startMM;
    private UiJLabel startMMLabel;
    private UiJLabel endLabel;
    private UiJTextField endYyyy;
    private UiJLabel endYyyyLabel;
    private UiJTextField endMm;
    private UiJLabel endMmLabel;
    private UiJTextField endDd;
    private UiJLabel endDdLabel;
    private UiJTextField endHH;
    private UiJLabel endHHLabel;
    private UiJTextField endMM;
    private UiJLabel endMMLabel;
    private UiJLabel projectCodeLabel;
    private JComboBox projectCodeBox;
    private UiJLabel phaseLabel;
    private JComboBox phaseBox;
    private UiJLabel workLabel;
    private JComboBox workBox;
    private UiJLabel progressLabel;
    private JSpinner progress;
    private UiJLabel progressLabel2;
    private JCheckBox closed;
    private UiJLabel closedLabel;
    private JCheckBox unFixed;
    private UiJLabel unFixedLabel;
    private JComboBox colorComboBox;
    private JTextArea commentTextArea;
    private JScrollPane commentJsp;
    private UiJButtonListener dsbl;
    private boolean editAble;
    private ProjectCodeList projectCodeList;
    private PhaseInfoListMap phaseInfoListMap;
    private WorkInfoListMap workInfoListMap;

    public DetailSchedulePanel4(UiJButtonListener dsbl, boolean editAble, ScheduleData sd, ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        this.dsbl = dsbl;
        this.editAble = editAble;
        this.projectCodeList = projectCodeList;
        this.phaseInfoListMap = phaseInfoListMap;
        this.workInfoListMap = workInfoListMap;
        this.initPanel(dsbl, editAble, sd, projectCodeList, phaseInfoListMap, workInfoListMap);
    }

    private void initPanel(UiJButtonListener dsbl, boolean editAble, ScheduleData sd, ProjectCodeList projectCodeList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        this.createUpdateButton(dsbl, editAble);
        this.createDeleteButton(dsbl, editAble);
        this.createImportButton(dsbl, editAble);
        this.createTitle(sd, editAble);
        this.createPlace(sd, editAble);
        this.createStartDateTime(sd, editAble);
        this.createEndDateTime(sd, editAble);
        if (sd.getProjectName().equals("")) {
            this.createProjectCode(projectCodeList.getProjectCodeName(sd.getPrj_code()), projectCodeList.getAllProjectCodeNameList(), editAble);
        } else {
            this.createProjectCode(String.valueOf(sd.getPrj_code()) + " " + sd.getProjectName(), projectCodeList.getAllProjectCodeNameList(), editAble);
        }
        if (sd.getProjectName().equals("")) {
            this.createPhase(sd.getPhaseName(), projectCodeList.makePhaseNameListByCodeName(phaseInfoListMap, projectCodeList.getProjectCodeName(sd.getPrj_code())), editAble);
        } else {
            this.createPhase(sd.getPhaseName(), projectCodeList.makePhaseNameListByCodeName(phaseInfoListMap, String.valueOf(sd.getPrj_code()) + " " + sd.getProjectName()), editAble);
        }
        this.createWork(sd.getWork(), projectCodeList.makeWorkNameList(workInfoListMap, sd.getPrj_code()), editAble);
        this.createProgress(sd.getProgressRatio(), editAble);
        this.createClosed(sd.isClosed(), editAble);
        this.createUnFixed(sd.isUnFixed(), editAble);
        this.createColorComboBox(editAble, CommonStatic.htmlScheduleColorList, sd.getColorInfo());
        this.createCommentTextArea(sd.getComment(), editAble);
        this.setLayoutManager();
    }

    private void setLayoutManager() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        hGroup.addGroup(layout.createSequentialGroup().addComponent(this.updateButton, 40, 100, Integer.MAX_VALUE).addComponent(this.deleteButton, 40, 100, Integer.MAX_VALUE).addComponent(this.importButton, 40, 100, Integer.MAX_VALUE));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addGroup(layout.createParallelGroup().addComponent(this.titleLabel).addComponent(this.placeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.title).addComponent(this.place)).addGap(2));
        hGroup.addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.startLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startYyyy, 40, 40, 40).addComponent(this.startYyyyLabel).addGap(2).addComponent(this.startMm, 20, 20, 20).addComponent(this.startMmLabel).addGap(2).addComponent(this.startDd, 20, 20, 20).addComponent(this.startDdLabel).addGap(2).addComponent(this.startHH, 20, 20, 20).addComponent(this.startHHLabel).addGap(2).addComponent(this.startMM, 20, 20, 20).addComponent(this.startMMLabel)).addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.endLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endYyyy, 40, 40, 40).addComponent(this.endYyyyLabel).addGap(2).addComponent(this.endMm, 20, 20, 20).addComponent(this.endMmLabel).addGap(2).addComponent(this.endDd, 20, 20, 20).addComponent(this.endDdLabel).addGap(2).addComponent(this.endHH, 20, 20, 20).addComponent(this.endHHLabel).addGap(2).addComponent(this.endMM, 20, 20, 20).addComponent(this.endMMLabel)));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addGroup(layout.createParallelGroup().addComponent(this.projectCodeLabel).addComponent(this.phaseLabel).addComponent(this.workLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.projectCodeBox).addComponent(this.phaseBox).addComponent(this.workBox)));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.progressLabel).addComponent(this.progress, 40, 40, 40).addComponent(this.progressLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closed).addComponent(this.closedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unFixed).addComponent(this.unFixedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorComboBox));
        hGroup.addGroup(layout.createSequentialGroup()).addComponent(this.commentJsp);
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateButton).addComponent(this.deleteButton).addComponent(this.importButton));
        vGroup.addGap(2);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.title));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.placeLabel).addComponent(this.place));
        vGroup.addGap(2);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startLabel).addComponent(this.startYyyy).addComponent(this.startYyyyLabel).addComponent(this.startMm).addComponent(this.startMmLabel).addComponent(this.startDd).addComponent(this.startDdLabel).addComponent(this.startHH).addComponent(this.startHHLabel).addComponent(this.startMM).addComponent(this.startMMLabel));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endLabel).addComponent(this.endYyyy).addComponent(this.endYyyyLabel).addComponent(this.endMm).addComponent(this.endMmLabel).addComponent(this.endDd).addComponent(this.endDdLabel).addComponent(this.endHH).addComponent(this.endHHLabel).addComponent(this.endMM).addComponent(this.endMMLabel));
        vGroup.addGap(2);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectCodeLabel).addComponent(this.projectCodeBox));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phaseLabel).addComponent(this.phaseBox));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.workLabel).addComponent(this.workBox));
        vGroup.addGap(1);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.progressLabel).addComponent(this.progress).addComponent(this.progressLabel2).addComponent(this.closed).addComponent(this.closedLabel).addComponent(this.unFixed).addComponent(this.unFixedLabel).addComponent(this.colorComboBox));
        vGroup.addGap(2);
        vGroup.addGroup(layout.createSequentialGroup()).addComponent(this.commentJsp);
        layout.setVerticalGroup(vGroup);
    }

    private void createUpdateButton(UiJButtonListener dsbl, boolean editAble) {
        this.updateButton = new UiJButton("\u66f4\u65b0", dsbl);
        if (!editAble) {
            this.updateButton.setEnabled(false);
        }
    }

    private void createDeleteButton(UiJButtonListener dsbl, boolean editAble) {
        this.deleteButton = new UiJButton("\u524a\u9664", dsbl);
        if (!editAble) {
            this.deleteButton.setEnabled(false);
        }
    }

    private void createImportButton(UiJButtonListener dsbl, boolean editAble) {
        this.importButton = new UiJButton("\u53d6\u8fbc", dsbl);
        if (!editAble) {
            this.importButton.setEnabled(false);
        }
    }

    private void createTitle(ScheduleData sd, boolean editAble) {
        this.titleLabel = new UiJLabel();
        this.titleLabel.setText("\u8868\u984c");
        this.title = new UiJTextField();
        this.title.setText(sd.getTitle());
        this.title.setEditable(editAble);
    }

    private void createPlace(ScheduleData sd, boolean editAble) {
        this.placeLabel = new UiJLabel();
        this.placeLabel.setText("\u5834\u6240");
        this.place = new UiJTextField();
        this.place.setText(sd.getPlace());
        this.place.setEditable(editAble);
    }

    private void createStartDateTime(ScheduleData sd, boolean editAble) {
        this.startLabel = new UiJLabel();
        this.startLabel.setText("\u958b\u59cb");
        this.startYyyy = new UiJTextField();
        this.startYyyy.setDocument(new LimitedNumeralDocument(4));
        this.startYyyy.enableInputMethods(false);
        this.startYyyy.setEditable(editAble);
        this.startYyyy.setText(sd.getS_date().getYyyy());
        this.startYyyyLabel = new UiJLabel();
        this.startYyyyLabel.setText("\u5e74");
        this.startMm = new UiJTextField();
        this.startMm.setDocument(new LimitedNumeralDocument(2));
        this.startMm.enableInputMethods(false);
        this.startMm.setEditable(editAble);
        this.startMm.setText(sd.getS_date().getMm());
        this.startMmLabel = new UiJLabel();
        this.startMmLabel.setText("\u6708");
        this.startDd = new UiJTextField();
        this.startDd.setDocument(new LimitedNumeralDocument(2));
        this.startDd.enableInputMethods(false);
        this.startDd.setEditable(editAble);
        this.startDd.setText(sd.getS_date().getDd());
        this.startDdLabel = new UiJLabel();
        this.startDdLabel.setText("\u65e5");
        this.startHH = new UiJTextField();
        this.startHH.setDocument(new LimitedNumeralDocument(2));
        this.startHH.enableInputMethods(false);
        this.startHH.setEditable(editAble);
        this.startHH.setText(sd.getS_date().getHH());
        this.startHHLabel = new UiJLabel();
        this.startHHLabel.setText("\u6642");
        this.startMM = new UiJTextField();
        this.startMM.setDocument(new LimitedNumeralDocument(2));
        this.startMM.enableInputMethods(false);
        this.startMM.setEditable(editAble);
        this.startMM.setText(sd.getS_date().getMM());
        this.startMMLabel = new UiJLabel();
        this.startMMLabel.setText("\u5206");
    }

    private void createEndDateTime(ScheduleData sd, boolean editAble) {
        this.endLabel = new UiJLabel();
        this.endLabel.setText("\u7d42\u4e86");
        this.endYyyy = new UiJTextField();
        this.endYyyy.setDocument(new LimitedNumeralDocument(4));
        this.endYyyy.enableInputMethods(false);
        this.endYyyy.setEditable(editAble);
        this.endYyyy.setText(sd.getE_date().getYyyy());
        this.endYyyyLabel = new UiJLabel();
        this.endYyyyLabel.setText("\u5e74");
        this.endMm = new UiJTextField();
        this.endMm.setDocument(new LimitedNumeralDocument(2));
        this.endMm.enableInputMethods(false);
        this.endMm.setEditable(editAble);
        this.endMm.setText(sd.getE_date().getMm());
        this.endMmLabel = new UiJLabel();
        this.endMmLabel.setText("\u6708");
        this.endDd = new UiJTextField();
        this.endDd.setDocument(new LimitedNumeralDocument(2));
        this.endDd.enableInputMethods(false);
        this.endDd.setEditable(editAble);
        this.endDd.setText(sd.getE_date().getDd());
        this.endDdLabel = new UiJLabel();
        this.endDdLabel.setText("\u65e5");
        this.endHH = new UiJTextField();
        this.endHH.setDocument(new LimitedNumeralDocument(2));
        this.endHH.enableInputMethods(false);
        this.endHH.setEditable(editAble);
        this.endHH.setText(sd.getE_date().getHH());
        this.endHHLabel = new UiJLabel();
        this.endHHLabel.setText("\u6642");
        this.endMM = new UiJTextField();
        this.endMM.setDocument(new LimitedNumeralDocument(2));
        this.endMM.enableInputMethods(false);
        this.endMM.setEditable(editAble);
        this.endMM.setText(sd.getE_date().getMM());
        this.endMMLabel = new UiJLabel();
        this.endMMLabel.setText("\u5206");
    }

    private void createProjectCode(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.projectCodeLabel = new UiJLabel();
        this.projectCodeLabel.setText("PRJ");
        this.projectCodeBox = new JComboBox();
        this.projectCodeBox.addActionListener(this);
        this.projectCodeBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.projectCodeBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            this.projectCodeBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.projectCodeBox.addItem(i.next());
            }
        }
        this.projectCodeBox.setSelectedItem(selectedValue);
        this.projectCodeBox.setEnabled(editAble);
        this.projectCodeBox.setEditable(true);
    }

    private void createPhase(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.phaseLabel = new UiJLabel();
        this.phaseLabel.setText("\u5de5\u7a0b");
        this.phaseBox = new JComboBox();
        this.phaseBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.phaseBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            this.phaseBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.phaseBox.addItem(i.next());
            }
        }
        this.phaseBox.setSelectedItem(selectedValue);
        this.phaseBox.setEnabled(editAble);
        this.phaseBox.setEditable(true);
    }

    private void createWork(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.workLabel = new UiJLabel();
        this.workLabel.setText("\u4f5c\u696d");
        this.workBox = new JComboBox();
        this.workBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.workBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            this.workBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.workBox.addItem(i.next());
            }
        }
        this.workBox.setSelectedItem(selectedValue);
        this.workBox.setEnabled(editAble);
        this.workBox.setEditable(true);
    }

    private void createProgress(int progressRatio, boolean editAble) {
        this.progressLabel = new UiJLabel();
        this.progressLabel.setText("\u5de5\u7a0b\u9032\u6357\u7387");
        this.progress = new JSpinner(new SpinnerNumberModel(progressRatio, 0, 100, 1));
        this.progress.enableInputMethods(false);
        this.progress.setEnabled(editAble);
        this.progressLabel2 = new UiJLabel();
        this.progressLabel2.setText("%");
    }

    private void createClosed(boolean closed, boolean editAble) {
        this.closed = new JCheckBox();
        this.closed.setSelected(closed);
        this.closed.setEnabled(editAble);
        this.closedLabel = new UiJLabel();
        this.closedLabel.setText("\u975e\u516c\u958b");
    }

    private void createUnFixed(boolean unFixed, boolean editAble) {
        this.unFixed = new JCheckBox();
        this.unFixed.setSelected(unFixed);
        this.unFixed.setEnabled(editAble);
        this.unFixedLabel = new UiJLabel();
        this.unFixedLabel.setText("\u4eee\u306e\u4e88\u5b9a");
    }

    private void createColorComboBox(boolean editAble, String[] dataList, int colorNo) {
        this.colorComboBox = new DetailScheduleJComboBox("Color", this);
        this.colorComboBox.setEnabled(editAble);
        this.colorComboBox.setModel(this.makeComboBoxModel(dataList));
        this.colorComboBox.setSelectedIndex(colorNo);
        this.colorComboBox.setPreferredSize(new Dimension(40, 22));
    }

    private DefaultComboBoxModel makeComboBoxModel(String[] dataList) {
        DefaultComboBoxModel<StringBuffer> comboBoxModel = new DefaultComboBoxModel<StringBuffer>();
        int i = 0;
        while (i < dataList.length) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html><font color=\"");
            sb.append(dataList[i]);
            sb.append("\">\u25a0</font></html>");
            comboBoxModel.addElement(sb);
            ++i;
        }
        return comboBoxModel;
    }

    private void createCommentTextArea(String comment, boolean editAble) {
        this.commentTextArea = new JTextArea(comment);
        this.commentTextArea.setEditable(editAble);
        this.commentJsp = new JScrollPane(this.commentTextArea);
        this.commentJsp.setVerticalScrollBarPolicy(22);
        this.commentJsp.setHorizontalScrollBarPolicy(32);
        this.commentJsp.setPreferredSize(new Dimension(200, 100));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.notifyComboBoxChanged("PRJ", (String)this.projectCodeBox.getSelectedItem());
    }

    @Override
    public void notifyComboBoxChanged(String title, String selectedProjectCodeName) {
        if (title.equals("PRJ")) {
            String selectedProjectCode = this.extractProjectCode(selectedProjectCodeName);
            if (this.phaseBox != null) {
                this.remove(this.phaseBox);
                String wkPhase = (String)this.phaseBox.getSelectedItem();
                this.createPhase(wkPhase, this.projectCodeList.makePhaseNameListByCodeName(this.phaseInfoListMap, selectedProjectCodeName), this.editAble);
            }
            if (this.workBox != null) {
                this.remove(this.workBox);
                String wkWork = (String)this.workBox.getSelectedItem();
                this.createWork(wkWork, this.projectCodeList.makeWorkNameList(this.workInfoListMap, selectedProjectCode), this.editAble);
            }
            if (this.phaseBox != null && this.workBox != null) {
                this.setLayoutManager();
            }
        }
    }

    public ScheduleData getScheduleData() {
        ScheduleData sd = new ScheduleData();
        sd.setTitle(this.title.getText());
        sd.setPlace(this.place.getText());
        DateInfo startDi = new DateInfo(this.startYyyy.getText(), this.startMm.getText(), this.startDd.getText(), this.startHH.getText(), this.startMM.getText());
        sd.setS_date(startDi);
        DateInfo endDi = new DateInfo(this.endYyyy.getText(), this.endMm.getText(), this.endDd.getText(), this.endHH.getText(), this.endMM.getText());
        sd.setE_date(endDi);
        sd.setPrj_code(this.extractProjectCode((String)this.projectCodeBox.getSelectedItem()));
        sd.setProjectName(this.extractProjectName((String)this.projectCodeBox.getSelectedItem()));
        sd.setPhaseName((String)this.phaseBox.getSelectedItem());
        sd.setWork((String)this.workBox.getSelectedItem());
        sd.setProgressRatio((Integer)this.progress.getValue());
        sd.setClosed(this.closed.isSelected());
        sd.setUnFixed(this.unFixed.isSelected());
        sd.setColorInfo(this.colorComboBox.getSelectedIndex());
        sd.setComment(this.commentTextArea.getText());
        return sd;
    }

    private String extractProjectCode(String projectCodeName) {
        String[] wkStr = projectCodeName.split(" ");
        return wkStr[0];
    }

    private String extractProjectName(String projectCodeName) {
        String[] wkStr = projectCodeName.split(" ");
        if (wkStr.length > 1) {
            String result = "";
            int i = 1;
            while (i < wkStr.length) {
                result = String.valueOf(result) + wkStr[i];
                result = String.valueOf(result) + " ";
                ++i;
            }
            return result;
        }
        return "";
    }
}

