/*
 * Decompiled with CFR 0.152.
 */
package uiMonthSchedule;

import commonData.CommonStatic;
import commonData.GhostGrassPane;
import commonData.MmDdHolder;
import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import commonData.YyyyMmHolder;
import configInfo.MonthPanelConfig;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.HolidayInfo;
import jScheduleData.JScheduleData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.border.LineBorder;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import uiMonthSchedule.MonthSchedulePanel3Listener;
import uiOneSchedule.ScheduleJLabel3;

public class MonthSchedulePanel3
extends JLayeredPane {
    static final long serialVersionUID = 0L;
    protected YyyyMmHolder currentMonth;
    protected UserInfo currentUserInfo;
    protected ArrayList<UserInfo> userInfoList;
    protected AllUserJScheduleData aujsd;
    protected HolidayInfo holidayInfo;
    protected HashMap<String, ArrayList<ScheduleJLabel3>> allUserSjl3 = new HashMap();
    protected int monthDays;
    protected final double xBase;
    protected final double yBase;
    protected final int startHH;
    protected final int endHH;
    protected final int dayHeader1;
    protected final int dayHeader2;
    protected final MonthPanelConfig monthPanelConfig;
    private Calendar cal;
    protected MonthSchedulePanel3Listener msp3l;
    protected boolean dndStatus = false;
    protected Point dndPoint = new Point();
    protected JLabel dndPointTime;
    protected GhostGrassPane ggp;
    protected Point ggpPoint;
    protected String updateMode;

    public MonthSchedulePanel3(MonthPanelConfig monthPanelConfig, double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH, int endHH, String yyyy, String mm, UserInfo currentUserInfo, ArrayList<UserInfo> userInfoList, AllUserJScheduleData aujsd, HolidayInfo holidayInfo, MonthSchedulePanel3Listener msp3l) {
        this.monthPanelConfig = monthPanelConfig;
        this.xBase = monthPanelConfig.getHolizontai_ratio_double();
        this.yBase = yBase;
        this.dayHeader1 = dayHeader1;
        this.dayHeader2 = dayHeader2;
        this.startHH = monthPanelConfig.getStartHHint();
        this.endHH = monthPanelConfig.getEndHHint();
        this.msp3l = msp3l;
        this.currentMonth = new YyyyMmHolder(yyyy, mm);
        this.currentUserInfo = currentUserInfo;
        this.userInfoList = userInfoList;
        this.aujsd = aujsd;
        this.holidayInfo = holidayInfo;
        this.initCalendar(Integer.valueOf(yyyy), Integer.valueOf(mm));
        this.initSchedulePanel();
    }

    private void initSchedulePanel() {
        this.setBackground(new Color(250, 250, 255));
        this.setOpaque(true);
        LineBorder border = new LineBorder(CommonStatic.borderColor);
        this.setBorder(border);
        this.setLayout(null);
        this.setPreferredSize(this.calcPreferrdSize());
        this.dndPointTime = new JLabel();
        this.dndPointTime.setVisible(false);
        this.dndPointTime.setFont(new Font("Arial", 1, 14));
        this.dndPointTime.setForeground(new Color(0, 0, 0));
        this.dndPointTime.setSize(new Dimension(50, 14));
        this.add(this.dndPointTime);
    }

    private Dimension calcPreferrdSize() {
        int width = (int)((double)(this.dayHeader1 + this.dayHeader2) + this.xBase * (double)(this.endHH - this.startHH) * 60.0);
        int height = (int)(31.0 * this.yBase);
        return new Dimension(width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.GRAY);
        this.fillLunchTime(g2);
        this.fillYoubi(g2);
        this.fillToday(g2);
        this.drawXLine(g2);
        this.drawYLine(g2);
        this.drawDayString(g2);
    }

    private void drawPointTime(Graphics g) {
        DateInfo sdi = this.calcPointTimeData(this.dndPoint.x, this.dndPoint.y, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, this.currentMonth.getYyyy(), this.currentMonth.getMm(), false);
        String pointTime = String.valueOf(sdi.getHH()) + ":" + sdi.getMM();
        g.drawString(pointTime, this.dndPoint.x, this.dndPoint.y);
    }

    private void fillToday(Graphics g) {
        if (this.currentMonth.isThereToday()) {
            MmDdHolder mmDd = new MmDdHolder();
            mmDd.setToday();
            g.setColor(CommonStatic.colorOfToday);
            g.fillRect(this.dayHeader1, (int)((double)(Integer.valueOf(mmDd.getTargetDd()) - 1) * this.yBase), (int)(this.xBase * (double)(this.endHH - this.startHH) * 60.0 + (double)this.dayHeader2), (int)this.yBase);
        }
    }

    private void fillLunchTime(Graphics g) {
        g.setColor(CommonStatic.colorOfLunchTime);
        g.fillRect((int)((double)(this.dayHeader1 + this.dayHeader2) + this.xBase * 60.0 * (double)(12 - this.startHH)), 0, (int)(this.xBase * 60.0), (int)(this.yBase * (double)this.monthDays));
    }

    private void fillYoubi(Graphics g) {
        int dayth = 1;
        while (dayth <= this.monthDays) {
            if (this.holidayInfo.isHoliday(this.currentMonth.getYyyy(), this.currentMonth.getMm(), Integer.toString(dayth))) {
                g.setColor(CommonStatic.colorOfHoliday);
                g.fillRect(0, (int)((double)(dayth - 1) * this.yBase), (int)(this.xBase * (double)(this.endHH - this.startHH) * 60.0 + (double)this.dayHeader1 + (double)this.dayHeader2), (int)this.yBase);
            }
            ++dayth;
        }
    }

    private void drawXLine(Graphics g) {
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(this.dayHeader1, 0, this.dayHeader1, (int)(this.yBase * (double)this.monthDays));
        g.drawLine(this.dayHeader1 + this.dayHeader2, 0, this.dayHeader1 + this.dayHeader2, (int)(this.yBase * (double)this.monthDays));
        int x = this.startHH;
        while (x <= this.endHH) {
            g.drawLine((int)(this.xBase * (double)(x - this.startHH) * 60.0 + (double)(this.dayHeader1 + this.dayHeader2)), 0, (int)(this.xBase * (double)(x - this.startHH) * 60.0 + (double)(this.dayHeader1 + this.dayHeader2)), (int)(this.yBase * (double)this.monthDays));
            ++x;
        }
    }

    private void drawYLine(Graphics g) {
        g.setColor(new Color(0, 0, 30));
        int y = 1;
        while (y <= this.monthDays) {
            g.drawLine(0, (int)(this.yBase * (double)y), (int)(this.xBase * (double)(this.endHH - this.startHH) * 60.0 + (double)this.dayHeader1 + (double)this.dayHeader2), (int)(this.yBase * (double)y));
            ++y;
        }
    }

    private void drawDayString(Graphics g) {
        String youbi = "";
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.valueOf(this.currentMonth.getYyyy()));
        cal.set(2, Integer.valueOf(this.currentMonth.getMm()) - 1);
        g.setFont(new Font("Times New Roman", 0, 11));
        int dayth = 1;
        while (dayth <= this.monthDays) {
            cal.set(5, dayth);
            switch (cal.get(7)) {
                case 2: {
                    g.setColor(CommonStatic.weekDay);
                    youbi = "Mon";
                    break;
                }
                case 3: {
                    g.setColor(CommonStatic.weekDay);
                    youbi = "Tue";
                    break;
                }
                case 4: {
                    g.setColor(CommonStatic.weekDay);
                    youbi = "Wed";
                    break;
                }
                case 5: {
                    g.setColor(CommonStatic.weekDay);
                    youbi = "Thu";
                    break;
                }
                case 6: {
                    g.setColor(CommonStatic.weekDay);
                    youbi = "Fri";
                    break;
                }
                case 7: {
                    g.setColor(CommonStatic.satDay);
                    youbi = "Sat";
                    break;
                }
                case 1: {
                    g.setColor(CommonStatic.sunDay);
                    youbi = "Sun";
                    break;
                }
                default: {
                    g.setColor(Color.GREEN);
                    youbi = "???";
                }
            }
            g.drawString(String.valueOf(dayth) + "(" + youbi + ")", 3, (int)(this.yBase * (double)(dayth - 1) + this.yBase - 5.0));
            ++dayth;
        }
    }

    public void removeSchedule(ScheduleData sd) {
    }

    protected ScheduleData calcDropedScheduleData(int x, int y, ScheduleData beforeSd, String updateMode) {
        ScheduleData sd = (ScheduleData)beforeSd.clone();
        if (updateMode.equals("S_TIME_UPDATE")) {
            sd.setS_date(this.calcPointTimeData(x, y, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, beforeSd.getS_date().getYyyy(), beforeSd.getS_date().getMm(), false));
        } else if (updateMode.equals("E_TIME_UPDATE")) {
            sd.setE_date(this.calcPointTimeData(x, y, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, beforeSd.getE_date().getYyyy(), beforeSd.getE_date().getMm(), false));
        } else if (updateMode.equals("MOVE_OR_COPY")) {
            sd = this.calcMovedScheduleData(x - this.ggpPoint.x, y - this.ggpPoint.y, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, beforeSd, true);
        } else if (updateMode.equals("NEW")) {
            sd = this.calcMovedScheduleData(x, y, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, beforeSd, false);
        } else {
            System.err.println("updateMode is notSet :\"" + updateMode + "\"\n");
        }
        return sd;
    }

    private ScheduleData calcMovedScheduleData(int x, int y, double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH, ScheduleData beforeSd, boolean moveOrCopy) {
        ScheduleData sd = (ScheduleData)beforeSd.clone();
        DateInfo sdi = this.calcPointTimeData(x, y, xBase, yBase, dayHeader1, dayHeader2, startHH, beforeSd.getS_date().getYyyy(), beforeSd.getS_date().getMm(), moveOrCopy);
        sd.setS_date(sdi);
        int sMin = Integer.valueOf(beforeSd.getS_date().getHH()) * 60 + Integer.valueOf(beforeSd.getS_date().getMM());
        int eMin = Integer.valueOf(beforeSd.getE_date().getHH()) * 60 + Integer.valueOf(beforeSd.getE_date().getMM());
        int width = eMin - sMin;
        sd.getE_date().setYyyy(beforeSd.getE_date().getYyyy());
        sd.getE_date().setMm(beforeSd.getE_date().getMm());
        sd.getE_date().setDd(sdi.getDd());
        sd.getE_date().setHH(sdi.getHH());
        sd.getE_date().setMM(sdi.getMM());
        sd.setEndDateFromTimeMinute(width);
        return sd;
    }

    private DateInfo calcPointTimeData(int x, int y, double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH, String yyyy, String mm, boolean moveOrCopy) {
        DateInfo di = new DateInfo();
        if (moveOrCopy) {
            y = (int)((double)y + yBase / 2.0);
        }
        int sHH = (int)((double)(x - dayHeader1 - dayHeader2) / xBase / 60.0) + startHH;
        int sMM = (int)((double)(x - dayHeader1 - dayHeader2) / xBase % 60.0);
        int sdd = (int)((double)y / yBase + 1.0);
        di.setYyyy(yyyy);
        di.setMm(mm);
        di.setDd(Integer.toString(sdd));
        di.setHH(Integer.toString(sHH));
        di.setMM(Integer.toString(sMM));
        if (this.monthPanelConfig.getDnd_ratio().equals("10")) {
            return this.roundedOff10(di);
        }
        if (this.monthPanelConfig.getDnd_ratio().equals("15")) {
            return this.roundedOff15(di);
        }
        return this.roundedOff30(di);
    }

    private DateInfo roundedOff10(DateInfo di) {
        DateInfo result = new DateInfo();
        result = (DateInfo)di.clone();
        if (Integer.valueOf(di.getMM()) > 0 && Integer.valueOf(di.getMM()) <= 4) {
            result.setMM("00");
        } else if (Integer.valueOf(di.getMM()) >= 5 && Integer.valueOf(di.getMM()) <= 14) {
            result.setMM("10");
        } else if (Integer.valueOf(di.getMM()) >= 15 && Integer.valueOf(di.getMM()) <= 24) {
            result.setMM("20");
        } else if (Integer.valueOf(di.getMM()) >= 25 && Integer.valueOf(di.getMM()) <= 34) {
            result.setMM("30");
        } else if (Integer.valueOf(di.getMM()) >= 35 && Integer.valueOf(di.getMM()) <= 44) {
            result.setMM("40");
        } else if (Integer.valueOf(di.getMM()) >= 45 && Integer.valueOf(di.getMM()) <= 54) {
            result.setMM("50");
        } else if (Integer.valueOf(di.getMM()) >= 55 && Integer.valueOf(di.getMM()) <= 59) {
            result.setHH(Integer.toString(Integer.valueOf(di.getHH()) + 1));
            result.setMM("00");
        }
        return result;
    }

    private DateInfo roundedOff15(DateInfo di) {
        DateInfo result = new DateInfo();
        result = (DateInfo)di.clone();
        if (Integer.valueOf(di.getMM()) > 0 && Integer.valueOf(di.getMM()) <= 7) {
            result.setMM("00");
        } else if (Integer.valueOf(di.getMM()) >= 8 && Integer.valueOf(di.getMM()) <= 22) {
            result.setMM("15");
        } else if (Integer.valueOf(di.getMM()) >= 23 && Integer.valueOf(di.getMM()) <= 37) {
            result.setMM("30");
        } else if (Integer.valueOf(di.getMM()) >= 38 && Integer.valueOf(di.getMM()) <= 52) {
            result.setMM("45");
        } else if (Integer.valueOf(di.getMM()) >= 53 && Integer.valueOf(di.getMM()) <= 59) {
            result.setHH(Integer.toString(Integer.valueOf(di.getHH()) + 1));
            result.setMM("00");
        }
        return result;
    }

    private DateInfo roundedOff30(DateInfo di) {
        DateInfo result = new DateInfo();
        result = (DateInfo)di.clone();
        if (Integer.valueOf(di.getMM()) > 0 && Integer.valueOf(di.getMM()) <= 14) {
            result.setMM("00");
        } else if (Integer.valueOf(di.getMM()) >= 15 && Integer.valueOf(di.getMM()) <= 44) {
            result.setMM("30");
        } else if (Integer.valueOf(di.getMM()) >= 45 && Integer.valueOf(di.getMM()) <= 59) {
            result.setHH(Integer.toString(Integer.valueOf(di.getHH()) + 1));
            result.setMM("00");
        }
        return result;
    }

    private void initCalendar(int yyyy, int mm) {
        this.cal = Calendar.getInstance();
        this.cal.set(1, yyyy);
        this.cal.set(2, mm - 1);
        this.monthDays = this.cal.getActualMaximum(5);
    }

    public ScheduleJLabel3 getSjl3(ScheduleData sd, UserInfo userInfo) {
        if (this.allUserSjl3.containsKey(userInfo.getUserId())) {
            ArrayList<ScheduleJLabel3> sjl3List = this.allUserSjl3.get(userInfo.getUserId());
            for (ScheduleJLabel3 sjl3 : sjl3List) {
                if (!sjl3.getScheduleData().compare(sd)) continue;
                return sjl3;
            }
        }
        return null;
    }

    public YyyyMmHolder getCurrnentMonth() {
        return this.currentMonth;
    }

    protected void setDndPointTime(Point dndPoint) {
        DateInfo sdi = this.calcPointTimeData(dndPoint.x, dndPoint.y, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, this.currentMonth.getYyyy(), this.currentMonth.getMm(), false);
        String pointTime = String.valueOf(sdi.getHH()) + ":" + sdi.getMM();
        this.dndPointTime.setText(pointTime);
        this.dndPointTime.setLocation(dndPoint.x + 2, dndPoint.y - 10);
        this.moveToFront(this.dndPointTime);
        this.dndPointTime.setVisible(true);
    }

    protected void checkOverlapInMonth(UserInfo userInfo, YyyyMmHolder yyyyMm) {
        if (!this.allUserSjl3.containsKey(userInfo.getUserId())) {
            return;
        }
        for (ScheduleJLabel3 sjl3 : this.allUserSjl3.get(userInfo.getUserId())) {
            sjl3.setOverlapMode(false);
        }
        YyyyMmDdHolder targetDay = new YyyyMmDdHolder();
        targetDay.setYyyy(yyyyMm.getYyyy());
        targetDay.setMm(yyyyMm.getMm());
        targetDay.setDd("01");
        while (yyyyMm.getMm().equals(targetDay.getMm())) {
            this.checkOverlapInDay(userInfo, targetDay, false);
            targetDay.inclementDd();
        }
    }

    protected void checkOverlapInDay(UserInfo userInfo, YyyyMmDdHolder targetDay, boolean initMode) {
        JScheduleData jsd = this.aujsd.getJScheduleData(userInfo);
        ArrayList<ScheduleData> sdList = jsd.getDayScheduleList2(targetDay);
        if (initMode) {
            for (ScheduleData sd : sdList) {
                ScheduleJLabel3 sjl3 = this.getSjl3(sd, userInfo);
                if (sjl3 == null) continue;
                sjl3.setOverlapMode(false);
            }
        }
        int index = 0;
        while (index < sdList.size()) {
            ScheduleData sd;
            sd = sdList.get(index);
            int target = index + 1;
            while (target < sdList.size()) {
                ScheduleData targetSd = sdList.get(target);
                if (sd.checkOverlap(targetSd)) {
                    ScheduleJLabel3 sjl3 = this.getSjl3(sd, userInfo);
                    if (sjl3 != null) {
                        sjl3.setOverlapMode(true);
                    }
                    if ((sjl3 = this.getSjl3(targetSd, userInfo)) != null) {
                        sjl3.setOverlapMode(true);
                    }
                }
                ++target;
            }
            ++index;
        }
    }
}

