/*
 * Decompiled with CFR 0.152.
 */
package uiMonthSchedule;

import commonData.GhostGrassPane;
import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import commonData.YyyyMmHolder;
import configInfo.MonthPanelConfig;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.HolidayInfo;
import jScheduleData.JScheduleData;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import scheduleData.ScheduleData;
import uiMonthSchedule.MonthSchedulePanel3;
import uiMonthSchedule.MonthSchedulePanel3Listener;
import uiOneSchedule.ScheduleJLabel3;
import uiOneSchedule.ScheduleJLabel3DataFlavor;
import uiOneSchedule.ScheduleJLabel3Listener;

public class MonthSchedulePanel3Imp
extends MonthSchedulePanel3
implements MouseListener,
ScheduleJLabel3Listener,
DropTargetListener {
    static final long serialVersionUID = 0L;
    private static int action = 3;
    private ScheduleData dropedScheduleData;
    private UserInfo dropedUserInfo;

    public MonthSchedulePanel3Imp(MonthPanelConfig monthPanelConfig, double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH, int endHH, String yyyy, String mm, UserInfo currentUserInfo, ArrayList<UserInfo> userInfoList, AllUserJScheduleData aujsd, HolidayInfo holidayInfo, MonthSchedulePanel3Listener msp3l) {
        super(monthPanelConfig, xBase, yBase, dayHeader1, dayHeader2, startHH, endHH, yyyy, mm, currentUserInfo, userInfoList, aujsd, holidayInfo, msp3l);
        this.addMonthSchedule(yyyy, mm, userInfoList, aujsd);
        this.addMouseListener(this);
        new DropTarget(this, action, this);
        this.repaint();
    }

    @Override
    public void requestRemove(ScheduleJLabel3 sjl3, boolean copyOrMove) {
        if (this.dropedScheduleData != null && this.dropedUserInfo != null) {
            if (this.dropedScheduleData.compare(sjl3.getScheduleData()) && this.dropedUserInfo.compareUserId(sjl3.getUserInfo())) {
                this.dropedScheduleData = null;
                this.dropedUserInfo = null;
                return;
            }
            if (copyOrMove) {
                this.msp3l.notifyAddSchedule(this.dropedScheduleData, this.dropedUserInfo);
            } else {
                this.msp3l.notifyAddSchedule(this.dropedScheduleData, this.dropedUserInfo);
                this.msp3l.notifyDndMoveSchedule(sjl3.getScheduleData(), sjl3.getUserInfo());
            }
            this.dropedScheduleData = null;
            this.dropedUserInfo = null;
        }
        this.checkOverlapInMonth(sjl3.getUserInfo(), this.currentMonth);
    }

    @Override
    public void notifyLeftSelected(ScheduleJLabel3 sjl3) {
        this.msp3l.notifyScheduleSelectOn(sjl3.getScheduleData(), sjl3.getUserInfo());
    }

    @Override
    public void notifyRightSelected(ScheduleJLabel3 sjl3, int x, int y) {
        this.msp3l.notifyRightClicked();
    }

    @Override
    public void notifyMiddleDoubleClicked(ScheduleJLabel3 sjl3) {
        ScheduleData sd = (ScheduleData)sjl3.getScheduleData().clone();
        sd.getS_date().incrementMm();
        sd.getE_date().incrementMm();
        UserInfo userInfo = sjl3.getUserInfo();
        this.msp3l.notifyAddSchedule(sd, userInfo);
    }

    @Override
    public void notifyDndStart(String updateMode, GhostGrassPane ggp, Point point) {
        this.ggp = ggp;
        this.ggpPoint = point;
        this.updateMode = updateMode;
        this.dndStatus = true;
        this.getRootPane().setGlassPane(ggp);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(action);
        Transferable tr = e.getTransferable();
        boolean gotData = false;
        ScheduleJLabel3 sjl3 = null;
        try {
            try {
                ScheduleJLabel3DataFlavor sjl3df = new ScheduleJLabel3DataFlavor();
                DataFlavor df = sjl3df.getDataFlavor();
                if (e.isDataFlavorSupported(df)) {
                    ScheduleData sd;
                    Point point = e.getLocation();
                    sjl3 = (ScheduleJLabel3)tr.getTransferData(df);
                    this.dropedScheduleData = sd = this.calcDropedScheduleData(point.x, point.y, sjl3.getScheduleData(), sjl3.getUpdateMode());
                    this.dropedUserInfo = sjl3.getUserInfo();
                    gotData = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.ggp.setVisible(false);
                this.ggp.setImage(null);
                this.dndPointTime.setVisible(false);
                this.dndStatus = false;
                e.dropComplete(gotData);
            }
        }
        finally {
            this.ggp.setVisible(false);
            this.ggp.setImage(null);
            this.dndPointTime.setVisible(false);
            this.dndStatus = false;
            e.dropComplete(gotData);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        Point pt;
        this.dndPoint = pt = e.getLocation();
        if (this.updateMode.equals("MOVE_OR_COPY")) {
            Point wkPt = this.calcGgpPoint(pt, this.msp3l.getLocationOfmsp3(), this.ggpPoint);
            this.ggp.setPoint(wkPt);
            this.ggp.repaint();
            this.ggp.setVisible(true);
        } else if (this.updateMode.equals("S_TIME_UPDATE") || this.updateMode.equals("E_TIME_UPDATE")) {
            this.setDndPointTime(pt);
        }
    }

    private Point calcGgpPoint(Point eventPoint, Point basePoint, Point startPoint) {
        Point wkPt = new Point(eventPoint.x + basePoint.x - startPoint.x + 2, eventPoint.y + basePoint.y + 36 - startPoint.y);
        return wkPt;
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getPoint().x > 0 && e.getPoint().x < this.dayHeader1) {
                Double wk = new Double((double)e.getPoint().y / this.yBase);
                int dd = wk.intValue() + 1;
                this.msp3l.notifyDaySchduleClicked(dd, e.getXOnScreen(), e.getYOnScreen());
            } else if (e.getClickCount() == 1) {
                this.msp3l.notifyScheduleSelectOff();
            } else if (e.getClickCount() == 2) {
                this.createSchedule(e.getPoint(), this.userInfoList);
            }
            this.msp3l.notifyLeftClicked();
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.msp3l.notifyRightClicked();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void selectOn(ScheduleData sd, UserInfo userInfo) {
        ScheduleJLabel3 sjl3 = this.getSjl3(sd, userInfo);
        if (sjl3 != null) {
            sjl3.selectOn();
            this.moveToFront(sjl3);
        }
    }

    public void selectOff(ScheduleData sd, UserInfo userInfo) {
        ScheduleJLabel3 sjl3 = this.getSjl3(sd, userInfo);
        if (sjl3 != null) {
            sjl3.selectOff();
            this.moveToBack(sjl3);
        }
    }

    private void addMonthSchedule(String yyyy, String mm, ArrayList<UserInfo> userIdList, AllUserJScheduleData aujsd) {
        for (UserInfo userInfo : userIdList) {
            TreeMap<String, ScheduleData> monthScheduleData;
            JScheduleData jsd = aujsd.getJScheduleData(userInfo);
            if (jsd != null && (monthScheduleData = jsd.getMonthSchedule(yyyy, mm)) != null) {
                Set<String> scheduleKeySet = monthScheduleData.keySet();
                for (String scheduleKey : scheduleKeySet) {
                    ScheduleData sd = monthScheduleData.get(scheduleKey);
                    this.addSchedule(sd, userInfo, false);
                }
            }
            this.checkOverlapInMonth(userInfo, new YyyyMmHolder(yyyy, mm));
        }
    }

    public void addSchedule(ScheduleData scheduleData, UserInfo userInfo) {
        this.addSchedule(scheduleData, userInfo, false);
    }

    public void addSchedule(ScheduleData scheduleData, UserInfo userInfo, boolean initMode) {
        if (this.userInfoList.contains(userInfo)) {
            ScheduleJLabel3 sjl3 = new ScheduleJLabel3(this, scheduleData, userInfo, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, this.endHH, this.currentUserInfo);
            if (this.allUserSjl3.containsKey(userInfo.getUserId())) {
                ((ArrayList)this.allUserSjl3.get(userInfo.getUserId())).add(sjl3);
            } else {
                ArrayList<ScheduleJLabel3> sjl3List = new ArrayList<ScheduleJLabel3>();
                sjl3List.add(sjl3);
                this.allUserSjl3.put(userInfo.getUserId(), sjl3List);
            }
            this.add(sjl3);
            this.moveToFront(sjl3);
            if (initMode) {
                YyyyMmDdHolder yyyyMmDd = new YyyyMmDdHolder();
                yyyyMmDd.setYyyy(scheduleData.getS_date().getYyyy());
                yyyyMmDd.setMm(scheduleData.getS_date().getMm());
                yyyyMmDd.setDd(scheduleData.getS_date().getDd());
                this.checkOverlapInDay(userInfo, yyyyMmDd, true);
            }
            this.repaint();
        }
    }

    public void delSchedule(ScheduleData sd, UserInfo userInfo) {
        if (this.allUserSjl3.containsKey(userInfo.getUserId())) {
            ArrayList sjl3List = (ArrayList)this.allUserSjl3.get(userInfo.getUserId());
            for (ScheduleJLabel3 sjl3 : sjl3List) {
                if (!sjl3.getScheduleData().compare(sd)) continue;
                sjl3List.remove(sjl3);
                this.remove(sjl3);
                YyyyMmDdHolder yyyyMmDd = new YyyyMmDdHolder();
                yyyyMmDd.setYyyy(sd.getS_date().getYyyy());
                yyyyMmDd.setMm(sd.getS_date().getMm());
                yyyyMmDd.setDd(sd.getS_date().getDd());
                this.checkOverlapInDay(userInfo, yyyyMmDd, true);
                this.revalidate();
                this.repaint();
                return;
            }
        }
    }

    private void createSchedule(Point point, ArrayList<UserInfo> userInfoList) {
        ScheduleData sd1 = new ScheduleData();
        sd1.getS_date().setYyyy(this.currentMonth.getYyyy());
        sd1.getS_date().setMm(this.currentMonth.getMm());
        sd1.getS_date().setDd("01");
        sd1.getS_date().setHH("00");
        sd1.getS_date().setMM("00");
        sd1.getE_date().setYyyy(this.currentMonth.getYyyy());
        sd1.getE_date().setMm(this.currentMonth.getMm());
        sd1.getE_date().setDd("01");
        sd1.getE_date().setHH("01");
        sd1.getE_date().setMM("00");
        ScheduleData sd2 = this.calcDropedScheduleData(point.x, point.y, sd1, "NEW");
        this.msp3l.notifyCreateSchedule(sd2, userInfoList);
    }
}

