/*
 * Decompiled with CFR 0.152.
 */
package uiOneSchedule;

import commonData.CommonStatic;
import commonData.GhostGrassPane;
import commonData.UserInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import scheduleData.ScheduleData;
import uiOneSchedule.ScheduleJLabel3DataFlavor;
import uiOneSchedule.ScheduleJLabel3Listener;
import uiOneSchedule.ScheduleTimeInfo;
import uiOneSchedule.ScheduleTitle;

public class ScheduleJLabel3
extends JPanel
implements MouseListener,
MouseMotionListener,
DragGestureListener,
Transferable,
Cloneable {
    static final long serialVersionUID = 0L;
    private DragSourceListener dsl = new DragSourceListener(){

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                ScheduleJLabel3.this.sjl3Listener.requestRemove(ScheduleJLabel3.this, ScheduleJLabel3.this.copyOrMove);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            Cursor dragCursor;
            if (dsde.getUserAction() == 1) {
                dragCursor = DragSource.DefaultCopyDrop;
                ScheduleJLabel3.this.copyOrMove = true;
            } else {
                dragCursor = DragSource.DefaultMoveDrop;
                ScheduleJLabel3.this.copyOrMove = false;
            }
            DragSourceContext dsc = dsde.getDragSourceContext();
            dsc.setCursor(dragCursor);
        }
    };
    boolean selectFlag;
    boolean dragFlag = false;
    int x = -1;
    int y = -1;
    private DragGestureRecognizer dgr;
    private String updateMode = "";
    public static final String S_TIME_UPDATE = "S_TIME_UPDATE";
    public static final String E_TIME_UPDATE = "E_TIME_UPDATE";
    public static final String MOVE_OR_COPY = "MOVE_OR_COPY";
    public static final String NEW = "NEW";
    public static final String NONE = "NONE";
    protected ScheduleData scheduleData;
    protected UserInfo userInfo;
    private int startHH;
    private int endHH;
    private double xBase;
    private double yBase;
    private int dayHeader1;
    private int dayHeader2;
    private Rectangle rectangle;
    private ScheduleJLabel3DataFlavor df = new ScheduleJLabel3DataFlavor();
    private ScheduleJLabel3Listener sjl3Listener;
    private boolean copyOrMove;
    private ScheduleTimeInfo timeInfo;
    protected UserInfo currentUserInfo;

    public ScheduleJLabel3() {
    }

    public ScheduleJLabel3(ScheduleJLabel3Listener sjl3Listener, ScheduleData sd, UserInfo userInfo, double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH, int endHH, UserInfo currentUserInfo) {
        this.setLayout(null);
        this.scheduleData = sd;
        this.userInfo = userInfo;
        this.xBase = xBase;
        this.yBase = yBase;
        this.dayHeader1 = dayHeader1;
        this.dayHeader2 = dayHeader2;
        this.startHH = startHH;
        this.endHH = endHH;
        this.sjl3Listener = sjl3Listener;
        this.currentUserInfo = currentUserInfo;
        this.rectangle = this.calcRectangle(sd, xBase, yBase, dayHeader1, dayHeader2, startHH);
        this.setBounds(this.rectangle);
        this.timeInfo = new ScheduleTimeInfo(this.scheduleData.getS_date().getHH(), this.scheduleData.getS_date().getMM());
        this.add(this.timeInfo);
        if (sd.isClosed() && !userInfo.isSame(currentUserInfo)) {
            this.add(new ScheduleTitle("\uff08\u975e\u516c\u958b\uff09", this.getWidth(), this.getHeight()));
        } else {
            this.add(new ScheduleTitle(sd.getTitle(), this.getWidth(), this.getHeight()));
        }
        this.setOpaque(false);
        LineBorder border = new LineBorder(this.createBorderColor(sd.getColorInfo(), userInfo.getEditMode(), this.userInfo.isGaoonUser(), this.userInfo.isNotesRoom()));
        this.setBorder(border);
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        float[] dist = new float[]{0.0f, 0.2f, 0.6f, 1.0f};
        Color startEndColor = this.createBackGroundColor(this.scheduleData.getColorInfo(), this.userInfo.getEditMode());
        Color backGroundColor = this.createBackGroundColor2(this.scheduleData.isUnFixed());
        Color[] colors = new Color[]{startEndColor, backGroundColor, startEndColor, startEndColor};
        LinearGradientPaint grad = new LinearGradientPaint(0.0f, 0.0f, 0.0f, 20.0f, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2.setPaint(grad);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        this.copyOrMove = this.isCopyOrDrag(e);
        Cursor dragCursor = DragSource.DefaultMoveDrop;
        if (this.copyOrMove) {
            dragCursor = DragSource.DefaultCopyDrop;
        }
        GhostGrassPane ggp = this.initGlassPane(e.getComponent(), e.getDragOrigin());
        this.sjl3Listener.notifyDndStart(this.updateMode, ggp, e.getDragOrigin());
        e.startDrag(dragCursor, this.getClone(this.currentUserInfo), this.dsl);
    }

    private boolean isCopyOrDrag(DragGestureEvent e) {
        boolean result = false;
        if (ScheduleJLabel3.isCtrlDown(e.getTriggerEvent())) {
            result = true;
        }
        return result;
    }

    private static boolean isCtrlDown(InputEvent e) {
        int mod = e.getModifiersEx();
        return (mod & 0x80) != 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.sjl3Listener.notifyLeftSelected(this);
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.sjl3Listener.notifyRightSelected(this, e.getX(), e.getY());
        } else if (SwingUtilities.isMiddleMouseButton(e) && e.getClickCount() == 2) {
            System.out.println("    Middle 2 Clicked");
            this.sjl3Listener.notifyMiddleDoubleClicked(this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        if (p.x < 5) {
            this.updateMode = S_TIME_UPDATE;
            this.setCursor(new Cursor(10));
            this.startDGR();
        } else if (p.x > this.rectangle.width - 5) {
            this.updateMode = E_TIME_UPDATE;
            this.setCursor(new Cursor(11));
            this.startDGR();
        } else if (p.y < 3 || p.y > this.rectangle.height - 5) {
            this.updateMode = MOVE_OR_COPY;
            this.setCursor(new Cursor(13));
            this.startDGR();
        } else {
            this.updateMode = NONE;
            this.setCursor(new Cursor(0));
            this.stopDGR();
        }
        this.repaint();
    }

    private Color createBackGroundColor(int colorInfo, boolean editMode) {
        Color color = editMode ? (colorInfo < CommonStatic.scheduleColorList.length ? CommonStatic.scheduleColorList[colorInfo] : CommonStatic.scheduleColorUnable) : CommonStatic.scheduleColorUnable;
        return color;
    }

    private Color createBackGroundColor2(boolean unFixMode) {
        Color color = unFixMode ? CommonStatic.unFixed : new Color(255, 255, 255);
        return color;
    }

    protected Color createBorderColor(int colorInfo, boolean editMode, boolean garoonUser, boolean notesRoom) {
        Color color = this.scheduleData.isWorkInfoEmpty() && !garoonUser && !notesRoom ? CommonStatic.scheduleBorderColorEmpty : (editMode ? (colorInfo < CommonStatic.scheduleBorderColorList.length ? CommonStatic.scheduleBorderColorList[colorInfo] : CommonStatic.scheduleBorderColorUnable) : CommonStatic.scheduleBorderColorUnable);
        return color;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] result = new DataFlavor[]{this.df.getDataFlavor()};
        return result;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.getHumanPresentableName().equals(this.df.getName());
    }

    public ScheduleJLabel3 getClone(UserInfo currentUserInfo) {
        ScheduleData sd = (ScheduleData)this.scheduleData.clone();
        ScheduleJLabel3 sjl3 = new ScheduleJLabel3(this.sjl3Listener, sd, this.userInfo, this.xBase, this.yBase, this.dayHeader1, this.dayHeader2, this.startHH, this.endHH, currentUserInfo);
        sjl3.updateMode = new String(this.updateMode);
        return sjl3;
    }

    public ScheduleData getScheduleData() {
        return this.scheduleData;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void selectOn() {
        this.selectFlag = true;
        if (this.userInfo.getEditMode()) {
            this.addMouseMotionListener(this);
        }
        LineBorder border = new LineBorder(Color.RED, 2);
        this.setBorder(border);
        this.repaint();
    }

    public void selectOff() {
        this.selectFlag = false;
        this.stopDGR();
        this.updateMode = NONE;
        this.removeMouseMotionListener(this);
        LineBorder border = new LineBorder(this.createBorderColor(this.scheduleData.getColorInfo(), this.userInfo.getEditMode(), this.userInfo.isGaoonUser(), this.userInfo.isNotesRoom()));
        this.setBorder(border);
        this.setCursor(new Cursor(0));
        this.repaint();
    }

    protected Rectangle calcRectangle(ScheduleData scheduleData, double xBase, double yBase, int dayHeader1, int dayHeader2, int startHH) {
        int sMin = 0;
        int eMin = 0;
        try {
            sMin = (Integer.valueOf(scheduleData.getS_date().getHH()) - startHH) * 60 + Integer.valueOf(scheduleData.getS_date().getMM());
            eMin = (Integer.valueOf(scheduleData.getE_date().getHH()) - startHH) * 60 + Integer.valueOf(scheduleData.getE_date().getMM());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(scheduleData.createScheduleDataKey());
            return null;
        }
        double tmpX = (double)sMin * xBase;
        int xPoint = (int)tmpX + dayHeader1 + dayHeader2;
        double tmpWidth = (double)(eMin - sMin) * xBase;
        int width = (int)tmpWidth;
        int yPoint = this.calcYPoint(yBase);
        int height = (int)yBase + 1;
        Rectangle rectangle = new Rectangle(xPoint, yPoint, width, height - 1);
        return rectangle;
    }

    protected int calcYPoint(double yBase) {
        int yPoint = (int)((double)(Integer.valueOf(this.scheduleData.getS_date().getDd()) - 1) * yBase);
        return yPoint;
    }

    public String getUpdateMode() {
        return this.updateMode;
    }

    private void startDGR() {
        if (this.dgr != null) {
            this.dgr.removeDragGestureListener(this);
            this.dgr = null;
        }
        this.dgr = new DragSource().createDefaultDragGestureRecognizer(this, 3, this);
    }

    private void stopDGR() {
        if (this.dgr != null) {
            this.dgr.removeDragGestureListener(this);
            this.dgr = null;
        }
    }

    private GhostGrassPane initGlassPane(Component c, Point tabPt) {
        GhostGrassPane glassPane = new GhostGrassPane();
        BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
        Graphics g = image.getGraphics();
        c.paint(g);
        glassPane.setImage(image);
        return glassPane;
    }

    public void setOverlapMode(boolean overlapMode) {
        this.timeInfo.setOverlap(overlapMode);
    }
}

