/*
 * Decompiled with CFR 0.152.
 */
package userInfoData;

import commonData.UserInfo;
import jScheduleData.JScheduleDataHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Logger;
import notesRoomsInfo.NotesRoom;
import notesRoomsInfo.NotesRooms;
import userInfoData.UserIndex;

public class UserInfoData {
    private UserInfo userInfoVector = new UserInfo("root", "root", false, false, true);

    public UserInfoData(UserInfo currentUserInfo) {
        this.userInfoVector.add(currentUserInfo);
    }

    public void createUserInfoListByDirpath(String userSpacename, String dirPathString) {
        File dirPath = new File(dirPathString);
        UserInfo userInfo = new UserInfo(userSpacename, userSpacename, false, false, false);
        this.userInfoVector.add(userInfo);
        this.createUserInfoListByDir(dirPath, null, userInfo);
    }

    public void createUserInfoList(String jsmFileName, UserIndex userIndex) {
        File currentJsmFile = new File(jsmFileName);
        File dirPath = currentJsmFile.getAbsoluteFile().getParentFile();
        ArrayList<UserInfo> userInfoList = new ArrayList();
        userInfoList = this.createUserInfoListByDir2(dirPath, currentJsmFile);
        this.createUserInfo(userIndex, this.userInfoVector, userInfoList);
        this.recoverInuseUserInfo(this.userInfoVector, userInfoList);
    }

    private void recoverInuseUserInfo(UserInfo userInfo, ArrayList<UserInfo> userInfoList) {
        for (UserInfo targetUserInfo : userInfoList) {
            if (userInfo.serchUserInfoByUserId(targetUserInfo.getUserId()) != null) continue;
            userInfo.add(targetUserInfo);
        }
    }

    private void createUserInfo(UserIndex currentUserIndex, UserInfo currentUserInfo, ArrayList<UserInfo> userInfoList) {
        for (UserIndex userIndex : currentUserIndex) {
            UserInfo userInfo = this.serchUserInfo(userIndex.getUser_id(), userInfoList);
            if (userInfo != null) {
                currentUserInfo.add(userInfo);
                this.createUserInfo(userIndex, userInfo, userInfoList);
                continue;
            }
            boolean isCurrentUser = false;
            if (currentUserInfo.equals(this.userInfoVector)) {
                for (UserInfo rootCurrentUserInfo : this.userInfoVector) {
                    if (!rootCurrentUserInfo.getUserId().equals(userIndex.getUser_id())) continue;
                    this.createUserInfo(userIndex, rootCurrentUserInfo, userInfoList);
                    isCurrentUser = true;
                }
            }
            if (isCurrentUser) continue;
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.warning("user_index not used \"" + userIndex.getUser_id() + "\"");
        }
    }

    private UserInfo serchUserInfo(String userId, ArrayList<UserInfo> userInfoList) {
        for (UserInfo userInfo : userInfoList) {
            if (!userInfo.getUserId().equals(userId)) continue;
            return userInfo;
        }
        return null;
    }

    private void createUserInfoListByDir(File dirPath, File currentJsmFile, UserInfo currentUserInfo) {
        if (dirPath.exists() && dirPath.canRead()) {
            File[] fileList = dirPath.listFiles();
            int i = 0;
            while (i < fileList.length) {
                File file = fileList[i];
                if (this.isJsmFile(file) && (currentJsmFile == null || !file.equals(currentJsmFile))) {
                    String userId = "";
                    userId = this.extractUserId(file.getPath());
                    if (userId != null) {
                        String userName = "";
                        userName = this.extractUserName(file);
                        if (userName != null) {
                            UserInfo userInfo = new UserInfo(userId, userName, false, true, true);
                            currentUserInfo.add(userInfo);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private ArrayList<UserInfo> createUserInfoListByDir2(File dirPath, File currentJsmFile) {
        ArrayList<UserInfo> result = new ArrayList<UserInfo>();
        if (dirPath.exists() && dirPath.canRead()) {
            File[] fileList = dirPath.listFiles();
            int i = 0;
            while (i < fileList.length) {
                File file = fileList[i];
                if (this.isJsmFile(file) && (currentJsmFile == null || !file.equals(currentJsmFile))) {
                    String userId = "";
                    userId = this.extractUserId(file.getPath());
                    if (userId != null) {
                        String userName = "";
                        userName = this.extractUserName(file);
                        if (userName != null) {
                            UserInfo userInfo = new UserInfo(userId, userName, false, true, true);
                            result.add(userInfo);
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public void createUserInfoFromNotesRooms(NotesRooms notesRooms) {
        UserInfo notesRootUser = new UserInfo("notes_root", "notes\u4f1a\u8b70\u5ba4");
        notesRootUser.setGaoonUser(true);
        notesRootUser.setHasScheduleData(false);
        UserInfo targetUserInfo = this.userInfoVector.serchUserInfo(notesRootUser);
        if (targetUserInfo == null) {
            this.addUserInfo(notesRootUser);
            targetUserInfo = notesRootUser;
        }
        for (NotesRoom notesRoom : notesRooms.getNotesRoomList()) {
            UserInfo userInfo = new UserInfo(notesRoom.getName(), notesRoom.getName(), false, true, true);
            userInfo.setGaoonUser(false);
            userInfo.setNotesRoom(true);
            this.addUserInfo(userInfo, targetUserInfo);
        }
    }

    private void addUserInfo(UserInfo userInfo) {
        this.userInfoVector.add(userInfo);
    }

    private void addUserInfo(UserInfo userInfo, UserInfo parentUserInfo) {
        UserInfo targetUserInfo = this.userInfoVector.serchUserInfo(parentUserInfo);
        if (targetUserInfo != null) {
            targetUserInfo.add(userInfo);
        } else {
            this.addUserInfo(userInfo);
        }
    }

    private String extractUserName(File file) {
        JScheduleDataHeader jsdh = new JScheduleDataHeader();
        if (jsdh.readHeader(file) < 0) {
            return null;
        }
        return jsdh.getUserName();
    }

    private String extractUserId(String fileName) {
        String[] tmpStr = fileName.split("\\\\|\\.");
        if (tmpStr.length >= 2) {
            return tmpStr[tmpStr.length - 2];
        }
        return null;
    }

    private boolean isJsmFile(File file) {
        return file.isFile() && file.canRead() && file.getName().endsWith(".jsm");
    }

    public UserInfo getRootUserInfo() {
        return this.userInfoVector;
    }

    public void printAll() {
        int count = 0;
        System.out.println("====> for debug, " + this.getClass().getName() + ", userInfoList");
        this.printUserInfo(count, this.userInfoVector);
    }

    private void printUserInfo(int count, UserInfo userInfo) {
        ListIterator i = userInfo.listIterator();
        while (i.hasNext()) {
            UserInfo wkUserInfo = (UserInfo)i.next();
            System.out.println("[" + count + "] id:" + wkUserInfo.getUserId() + ", name: " + wkUserInfo.getUserName() + ", kind: " + wkUserInfo.isGaoonUser() + ", mode: " + wkUserInfo.getEditMode());
            ++count;
            if (wkUserInfo.isEmpty()) continue;
            this.printUserInfo(count, wkUserInfo);
        }
    }
}

