/*
 * Decompiled with CFR 0.152.
 */
package workMasterData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import workMasterData.Assignment;
import workMasterData.Assignments;
import workMasterData.PhaseInfo;

public class PhaseInfoList {
    ArrayList<PhaseInfo> phaseInfoList = new ArrayList();

    public ArrayList<PhaseInfo> getPhaseInfoList() {
        return this.phaseInfoList;
    }

    public void setPhaseInfoList(ArrayList<PhaseInfo> phaseInfoList) {
        this.phaseInfoList = phaseInfoList;
    }

    public void setPhaseInfo(PhaseInfo phaseInfo) {
        this.phaseInfoList.add(phaseInfo);
    }

    public ArrayList<String> getAllPhaseNameList() {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo phaseInfo : this.phaseInfoList) {
            result.add(phaseInfo.getName());
        }
        return result;
    }

    public ArrayList<String> getUpperLevelPhaseNameList(int wbsLevel) {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo phaseInfo : this.phaseInfoList) {
            if (phaseInfo.getWbsLevel() > wbsLevel) continue;
            result.add(phaseInfo.getName());
        }
        return result;
    }

    public ArrayList<String> getAllPhaseNameList(ArrayList<String> assignmentList) {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo phaseInfo : this.phaseInfoList) {
            if (!phaseInfo.isAssignments(assignmentList)) continue;
            result.add(phaseInfo.getName());
        }
        return result;
    }

    public ArrayList<String> getPhaseNameListWithAssignment(Assignments assignments) {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo phaseInfo : this.phaseInfoList) {
            for (Assignment assignment : assignments.getAssignMentList()) {
                if (!phaseInfo.getAssignments().getAssignmentMap().containsKey(assignment.getResourcename())) continue;
                result.add(phaseInfo.getName());
            }
        }
        return result;
    }

    public ArrayList<String> getPhaseNameListWithUppserPhase(String upperPhase) {
        ArrayList<String> result = new ArrayList<String>();
        PhaseInfo upperPhaseInfo = null;
        for (PhaseInfo phaseInfo : this.phaseInfoList) {
            if (!phaseInfo.getName().equals(upperPhase)) continue;
            upperPhaseInfo = phaseInfo;
            break;
        }
        if (upperPhaseInfo != null) {
            for (PhaseInfo phaseInfo : this.phaseInfoList) {
                if (!upperPhaseInfo.checkUnderPhase(phaseInfo.getName())) continue;
                result.add(phaseInfo.getName());
            }
        }
        return result;
    }

    public HashMap<String, Assignment> getAllAssignmentMap() {
        HashMap<String, Assignment> resultMap = new HashMap<String, Assignment>();
        for (PhaseInfo phaseInfo : this.phaseInfoList) {
            HashMap<Object, Object> wkMap = new HashMap();
            wkMap = phaseInfo.getAssignments().getAllAssignmentName();
            Set<Object> wkMapList = wkMap.keySet();
            for (String string : wkMapList) {
                if (resultMap.containsKey(string)) continue;
                resultMap.put(string, (Assignment)wkMap.get(string));
            }
        }
        return resultMap;
    }

    public String getPhaseNameWBSLevel(String phaseName, int wbsLevel) {
        String result = "";
        boolean isThere = false;
        for (PhaseInfo phaseInfo : this.phaseInfoList) {
            if (phaseInfo.getName().equals(phaseName)) {
                isThere = true;
            }
            if (phaseInfo.getWbsLevel() != wbsLevel || !phaseInfo.checkUnderPhase(phaseName)) continue;
            result = phaseInfo.getName();
        }
        if (isThere) {
            return result;
        }
        return "";
    }
}

