/*
 * Decompiled with CFR 0.152.
 */
package workMasterData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import workMasterData.Assignment;
import workMasterData.Assignments;
import workMasterData.PhaseInfo2;

public class PhaseInfoList2 {
    ArrayList<PhaseInfo2> phaseInfoList = new ArrayList();
    HashMap<Integer, PhaseInfo2> phaseInfoMap = new HashMap();
    PhaseInfo2 phaseInfoRoot = new PhaseInfo2();

    public ArrayList<PhaseInfo2> getPhaseInfoList() {
        return this.phaseInfoList;
    }

    public void setPhaseInfo(PhaseInfo2 phaseInfo) {
        this.phaseInfoList.add(phaseInfo);
        this.setPhaseInfoMap(phaseInfo);
        this.setPhaseInfoVector(phaseInfo);
    }

    private void setPhaseInfoVector(PhaseInfo2 phaseInfo) {
        if (this.phaseInfoMap.containsKey(phaseInfo.getParentId())) {
            this.phaseInfoMap.get(phaseInfo.getParentId()).add(phaseInfo);
        } else {
            this.phaseInfoRoot.add(phaseInfo);
        }
    }

    private void setPhaseInfoMap(PhaseInfo2 phaseInfo) {
        if (this.phaseInfoMap.containsKey(phaseInfo.getUniqueid())) {
            System.err.println(String.valueOf(this.getClass().getName()) + " uniqueId is empty.");
            phaseInfo.printAll();
        } else {
            this.phaseInfoMap.put(phaseInfo.getUniqueid(), phaseInfo);
        }
    }

    public ArrayList<String> getAllPhaseNameList() {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
            result.add(phaseInfo.getPhaseName());
        }
        return result;
    }

    public ArrayList<String> getUpperLevelPhaseNameList(int wbsLevel) {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
            if (phaseInfo.getWbsLevel() > wbsLevel) continue;
            result.add(phaseInfo.getPhaseName());
        }
        return result;
    }

    public ArrayList<String> getAllPhaseNameList(ArrayList<String> assignmentList) {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
            if (!phaseInfo.isAssignments(assignmentList)) continue;
            result.add(phaseInfo.getPhaseName());
        }
        return result;
    }

    public ArrayList<String> getPhaseNameListWithAssignment(Assignments assignments) {
        ArrayList<String> result = new ArrayList<String>();
        for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
            for (Assignment assignment : assignments.getAssignMentList()) {
                if (!phaseInfo.getAssignments().getAssignmentMap().containsKey(assignment.getResourcename())) continue;
                result.add(phaseInfo.getPhaseName());
            }
        }
        return result;
    }

    public ArrayList<String> getPhaseNameListWithUppserPhase(String upperPhase) {
        ArrayList<String> result = new ArrayList<String>();
        PhaseInfo2 upperPhaseInfo = null;
        for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
            if (!phaseInfo.getPhaseName().equals(upperPhase)) continue;
            upperPhaseInfo = phaseInfo;
            break;
        }
        if (upperPhaseInfo != null) {
            for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
                if (!upperPhaseInfo.checkUnderPhase(phaseInfo.getPhaseName())) continue;
                result.add(phaseInfo.getPhaseName());
            }
        }
        return result;
    }

    public HashMap<String, Assignment> getAllAssignmentMap() {
        HashMap<String, Assignment> resultMap = new HashMap<String, Assignment>();
        for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
            HashMap<Object, Object> wkMap = new HashMap();
            wkMap = phaseInfo.getAssignments().getAllAssignmentName();
            Set<Object> wkMapList = wkMap.keySet();
            for (String string : wkMapList) {
                if (resultMap.containsKey(string)) continue;
                resultMap.put(string, (Assignment)wkMap.get(string));
            }
        }
        return resultMap;
    }

    public String getPhaseNameWBSLevel(String phaseName, int wbsLevel) {
        String result = "";
        boolean isThere = false;
        for (PhaseInfo2 phaseInfo : this.phaseInfoList) {
            if (phaseInfo.getPhaseName().equals(phaseName)) {
                isThere = true;
            }
            if (phaseInfo.getWbsLevel() != wbsLevel || !phaseInfo.checkUnderPhase(phaseName)) continue;
            result = phaseInfo.getPhaseName();
        }
        if (isThere) {
            return result;
        }
        return "";
    }
}

