/*
 * Decompiled with CFR 0.152.
 */
package workMasterData;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import workMasterData.PhaseListFile;
import workMasterData.ProjectItem;
import workMasterData.ProjectUnit;
import workMasterData.WorkListFile;

public class ProjectUnitList {
    private HashMap<String, ProjectUnit> projectUnitMap = new HashMap();

    public void setProjectUnit(ProjectUnit projectUnit) {
        this.projectUnitMap.put(projectUnit.getName(), projectUnit);
    }

    public ArrayList<String> getAllProjectUnitNameList() {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        Iterator<String> i = projectUnitNameList.iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        Collections.sort(result);
        return result;
    }

    public ArrayList<String> getAllPhaseNameFileList() {
        ArrayList<String> phaseNameFileList = new ArrayList<String>();
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        Iterator<String> i = projectUnitNameList.iterator();
        while (i.hasNext()) {
            ProjectUnit projectUnit = this.projectUnitMap.get(i.next());
            for (PhaseListFile phaseListFile : projectUnit.getPhaseListFiles().getPhaseListFileList()) {
                String fileName = phaseListFile.getFile_name();
                if (phaseNameFileList.contains(fileName)) continue;
                phaseNameFileList.add(fileName);
            }
        }
        return phaseNameFileList;
    }

    public ArrayList<String> getAllWorkNameFileList() {
        ArrayList<String> workNameFileList = new ArrayList<String>();
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        Iterator<String> i = projectUnitNameList.iterator();
        while (i.hasNext()) {
            ProjectUnit projectUnit = this.projectUnitMap.get(i.next());
            for (WorkListFile workListFile : projectUnit.getWorkListFiles().getWorkListFileList()) {
                String fileName = workListFile.getFile_name();
                if (workNameFileList.contains(fileName)) continue;
                workNameFileList.add(fileName);
            }
        }
        return workNameFileList;
    }

    public ArrayList<String> getAllProjectCodeNameList() {
        ArrayList<String> projectCodeNameList = new ArrayList<String>();
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        Iterator<String> i = projectUnitNameList.iterator();
        while (i.hasNext()) {
            ProjectUnit projectUnit = this.projectUnitMap.get(i.next());
            for (String projectCodeName : projectUnit.getProjectItems().getAllProjectCodeNameList()) {
                if (projectCodeNameList.contains(projectCodeName)) continue;
                projectCodeNameList.add(projectCodeName);
            }
        }
        return projectCodeNameList;
    }

    public ArrayList<String> getPhaseNameFileList(String targetName) {
        ArrayList<String> phaseNameFileList = new ArrayList<String>();
        if (this.projectUnitMap.containsKey(targetName)) {
            for (PhaseListFile phaseListFile : this.projectUnitMap.get(targetName).getPhaseListFiles().getPhaseListFileList()) {
                String fileName = phaseListFile.getFile_name();
                if (phaseNameFileList.contains(fileName)) continue;
                phaseNameFileList.add(fileName);
            }
        }
        return phaseNameFileList;
    }

    public String getProjectName(String projectCode) {
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        Iterator<String> i = projectUnitNameList.iterator();
        while (i.hasNext()) {
            ProjectUnit projectUnit = this.projectUnitMap.get(i.next());
            for (ProjectItem projectItem : projectUnit.getProjectItems().getProjectItemList()) {
                if (!projectItem.getCode().equals(projectCode)) continue;
                return projectItem.getName();
            }
        }
        return "";
    }

    public ProjectUnit getProjectUnit(String projectUnitName) {
        if (this.projectUnitMap.containsKey(projectUnitName)) {
            return this.projectUnitMap.get(projectUnitName);
        }
        return new ProjectUnit();
    }

    public ArrayList<String> getProjectUnitNameList() {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        Iterator<String> i = projectUnitNameList.iterator();
        while (i.hasNext()) {
            ProjectUnit projectUnit = this.projectUnitMap.get(i.next());
            result.add(projectUnit.getName());
        }
        return result;
    }

    public ArrayList<ProjectUnit> getProjectUnitList() {
        ArrayList<ProjectUnit> result = new ArrayList<ProjectUnit>();
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        for (String projectUnitName : projectUnitNameList) {
            result.add(this.projectUnitMap.get(projectUnitName));
        }
        return result;
    }

    public void addProjectUnitList(ArrayList<ProjectUnit> projectUnitList) {
        for (ProjectUnit projectUnit : projectUnitList) {
            if (!this.projectUnitMap.containsKey(projectUnit.getName())) {
                this.projectUnitMap.put(projectUnit.getName(), projectUnit);
                continue;
            }
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.warning("This projectUnitName is already used. [" + projectUnit.getName() + "]");
        }
    }

    public String getProjectCodeNameFromAllProjectUnit(String projectCode) {
        String result = "";
        Set<String> projectUnitNameList = this.projectUnitMap.keySet();
        for (String projectUnitName : projectUnitNameList) {
            ProjectUnit projectUnit = this.projectUnitMap.get(projectUnitName);
            result = projectUnit.getProjectItems().getProjectCodeName(projectCode);
            if (result.equals(projectCode)) continue;
            return result;
        }
        return result;
    }
}

