/*
 * Decompiled with CFR 0.152.
 */
package workResultData;

import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import jScheduleData.AllUserJScheduleData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectUnitList;
import workResultData.OneWorkResultData;

public class WorkResultData {
    private ArrayList<OneWorkResultData> workResultDataList = new ArrayList();

    public WorkResultData() {
    }

    public WorkResultData(AllUserJScheduleData aujsd, ArrayList<UserInfo> userInfoList, ProjectUnitList projectUnitList, PhaseInfoListMap phaseInfoListMap, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd) {
        for (UserInfo userInfo : userInfoList) {
            DateInfo di = new DateInfo("0000", "00", "00", "00", "00");
            for (ScheduleData sd : aujsd.getJScheduleData(userInfo).getScheduleListAfterDateInfo(di)) {
                if (!this.isScopeOn(sd, startYyyyMmDd, endYyyyMmDd)) continue;
                String prjName = projectUnitList.getProjectUnit(sd.getProjectUnitName()).getProjectItems().getProjectName(sd.getPrj_code());
                String upperPhaseName = phaseInfoListMap.getUpperPhaseName(projectUnitList.getProjectUnit(sd.getProjectUnitName()).getPhaseListFiles().makePhaseFileNameList(), sd.getPhaseName(), 2);
                OneWorkResultData owrd = new OneWorkResultData(sd, userInfo, prjName, upperPhaseName);
                this.workResultDataList.add(owrd);
            }
        }
    }

    private boolean isScopeOn(ScheduleData sd, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd) {
        DateInfo sDi = new DateInfo(startYyyyMmDd.getYyyy(), startYyyyMmDd.getMm(), startYyyyMmDd.getDd(), "00", "00");
        if (sd.getS_date().compareDateInfo(sDi) == -1) {
            return false;
        }
        DateInfo eDi = new DateInfo(endYyyyMmDd.getYyyy(), endYyyyMmDd.getMm(), endYyyyMmDd.getDd(), "23", "59");
        return sd.getE_date().compareDateInfo(eDi) != 1;
    }

    public int writeCsvFile(File file) {
        BufferedWriter bw;
        block3: {
            bw = null;
            try {
                bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                if (this.writeBody(bw) >= 0) break block3;
                return -2;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e" + file.getPath());
                return -1;
            }
        }
        bw.close();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int writeBody(BufferedWriter bw) {
        try {
            OneWorkResultData owrd;
            if (this.writeWorkResultDataHeader(bw) < 0) {
                System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e-1");
                return -1;
            }
            Iterator<OneWorkResultData> i = this.workResultDataList.iterator();
            do {
                if (i.hasNext()) continue;
                return 0;
            } while (this.writeOneWorkResultData(bw, owrd = i.next()) >= 0);
            System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e-2");
            return -2;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e-3");
            return -3;
        }
    }

    private int writeWorkResultDataHeader(BufferedWriter bw) {
        try {
            bw.write("user,yyyy,mm,dd,HH,MM,project_unit_name,project_code,project_name,title,upper_phase,phase,work,workTime,progressRatio,comment");
            bw.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\u30d5\u30a1\u30a4\u30eb\u5165\u51fa\u529b\u3067\u4e0d\u6b63\u306a\u51e6\u7406\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e-1");
            return -1;
        }
        return 0;
    }

    private int writeOneWorkResultData(BufferedWriter bw, OneWorkResultData owrd) {
        try {
            bw.write(String.valueOf(owrd.getUserInfo().getUserId()) + "," + owrd.getYyyyMmDd().getYyyy() + "," + owrd.getYyyyMmDd().getMm() + "," + owrd.getYyyyMmDd().getDd() + "," + owrd.getSDate().getHH() + "," + owrd.getSDate().getMM() + "," + owrd.getProjectUnitName() + "," + owrd.getPrjCode() + "," + owrd.getPrjName() + "," + owrd.getTitle() + "," + owrd.getUpperPhaseName() + "," + owrd.getWbsNo() + "." + owrd.getPhase() + "," + owrd.getWork() + "," + owrd.getWorkTime() + "," + owrd.getProgressRatio() + "," + "\"" + owrd.getComment() + "\"");
            bw.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }
}

