/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.dialog;

import java.util.ArrayList;
import java.util.regex.Pattern;
import jp.nimbus.ide.dialog.SimpleSelectionDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExtendedSelectionDialog
extends SimpleSelectionDialog {
    private ExtensionType extensionType = ExtensionType.None;
    private Text extensionText;
    private static Pattern digitPattern = Pattern.compile("[0-9]+");

    public ExtendedSelectionDialog(Shell parent, String title, String description, String[] collection, String selection) {
        super(parent, title, description, collection, selection);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite extensionPanel = new Composite(composite, 0);
        extensionPanel.setLayoutData((Object)new GridData(768));
        extensionPanel.setLayout((Layout)new GridLayout(1, false));
        Composite optionsPanel = new Composite(extensionPanel, 0);
        optionsPanel.setLayoutData((Object)new GridData(768));
        optionsPanel.setLayout((Layout)new GridLayout(2, false));
        Button button1 = new Button(optionsPanel, 16);
        button1.setText("\u306a\u3057");
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedSelectionDialog.this.extensionType = ExtensionType.Indexer;
            }
        });
        button1.setSelection(true);
        Button button2 = new Button(optionsPanel, 16);
        button2.setText("\u30a4\u30f3\u30c7\u30af\u30b5");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedSelectionDialog.this.extensionType = ExtensionType.Indexer;
            }
        });
        Button button3 = new Button(optionsPanel, 16);
        button3.setText("\u30d7\u30ed\u30d1\u30c6\u30a3");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedSelectionDialog.this.extensionType = ExtensionType.Property;
            }
        });
        this.extensionText = new Text(extensionPanel, 2048);
        this.extensionText.setLayoutData((Object)new GridData(768));
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExtendedSelectionDialog.this.extensionText.setText("");
            }
        });
        return composite;
    }

    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        String selectionString = (String)selection.getFirstElement();
        String extensionString = this.extensionText.getText();
        if (selectionString != null && extensionString != null && extensionString.length() > 0) {
            if (this.extensionType == ExtensionType.Indexer) {
                extensionString = digitPattern.matcher(extensionString).matches() ? "[" + extensionString + "]" : "(" + extensionString + ")";
            } else if (this.extensionType == ExtensionType.Property) {
                extensionString = "." + extensionString;
            }
            selectionString = String.valueOf(selectionString) + extensionString;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(selectionString);
        this.setResult(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExtensionType {
        None,
        Indexer,
        Property;

    }
}

