/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editor;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jp.nimbus.ide.ProjectHandler;
import jp.nimbus.ide.beanflow.editor.BeanFlowGraphicalEditor;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.FlowCollection;
import jp.nimbus.ide.util.ErrorHandler;
import jp.nimbus.ide.xml.editor.XMLEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheet;

public class BeanFlowEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    public static final String EDITOR_ID = BeanFlowEditor.class.getName();
    private FlowCollection flows;
    private XMLEditor textEditor;
    private int currentPageIndex = -1;
    private AtomicBoolean pageChanging = new AtomicBoolean(false);
    private PropertySheet propertySheet;

    protected void createPages() {
        this.flows = new FlowCollection((FileEditorInput)this.getEditorInput());
        try {
            this.flows.read();
        }
        catch (Exception e) {
            ErrorHandler.handle((WorkbenchPart)this, e);
        }
        for (Flow flow : this.flows.getFlows()) {
            GraphicalEditor graphicalEditor = this.createGraphicalEditor(flow);
            this.addPage((IEditorPart)graphicalEditor, flow.getName());
        }
        this.textEditor = new XMLEditor();
        this.addPage((IEditorPart)this.textEditor, "Source");
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        super.init(site, editorInput);
        this.setPartName(this.getEditorInput().getName());
        this.loadProject();
    }

    private void loadProject() {
        IProject project = ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ProjectHandler.setCurrentProject(javaProject);
        try {
            javaProject.findElement((IPath)new Path(""));
        }
        catch (JavaModelException e) {
            ErrorHandler.handle(this.getSite().getShell(), (Exception)((Object)e));
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        if (!this.pageChanging.get()) {
            this.pageChanging = new AtomicBoolean(true);
            int pageCount = this.getPageCount();
            if (this.currentPageIndex == pageCount - 1) {
                this.synchronizeWithTextEditor();
            } else if (newPageIndex == pageCount - 1) {
                this.synchronizeWithGraphicalEditors();
            }
            super.pageChange(newPageIndex);
            this.currentPageIndex = newPageIndex;
            this.setActivePage(newPageIndex);
            this.pageChanging = new AtomicBoolean(false);
        }
    }

    private boolean isDirtyInGraphicalEditors() {
        boolean dirty = false;
        int pageCount = this.getPageCount();
        int i = 0;
        while (i < pageCount - 1) {
            if (this.getEditor(i).isDirty()) {
                dirty = true;
                break;
            }
            ++i;
        }
        return dirty;
    }

    private void synchronizeWithGraphicalEditors() {
        if (this.isDirtyInGraphicalEditors()) {
            this.updateTextEditor();
        }
    }

    private void updateTextEditor() {
        IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.getEditorInput());
        try {
            document.set(this.flows.getContentAsStirng());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void synchronizeWithTextEditor() {
        if (this.textEditor.isDirty()) {
            block20: {
                IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.getEditorInput());
                while (this.getPageCount() > 1) {
                    this.removePage(0);
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(document.get().getBytes());
                BufferedInputStream inputStream = new BufferedInputStream(bis);
                try {
                    try {
                        this.flows.read(inputStream);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (bis != null) {
                                bis.close();
                            }
                            break block20;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (bis != null) {
                            bis.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            List<Flow> flowList = this.flows.getFlows();
            Collections.reverse(flowList);
            for (Flow flow : flowList) {
                GraphicalEditor graphicalEditor = this.createGraphicalEditor(flow);
                this.insertPage((IEditorPart)graphicalEditor, flow.getName());
                this.activateGraphicalEditor(graphicalEditor);
            }
        }
    }

    private void activateGraphicalEditor(GraphicalEditor graphicalEditor) {
        if (this.propertySheet != null) {
            try {
                this.propertySheet.partActivated((IWorkbenchPart)graphicalEditor);
            }
            catch (Exception exception) {}
        }
    }

    private GraphicalEditor createGraphicalEditor(Flow flow) {
        BeanFlowGraphicalEditor graphicalEditor = new BeanFlowGraphicalEditor(this, flow);
        return graphicalEditor;
    }

    public void doSave(IProgressMonitor monitor) {
        this.pageChanging = new AtomicBoolean(true);
        this.synchronizeWithTextEditor();
        this.synchronizeWithGraphicalEditors();
        this.pageChanging = new AtomicBoolean(false);
        this.textEditor.doSave(monitor);
        int pageCount = this.getPageCount();
        int i = 0;
        while (i < pageCount) {
            IEditorPart editorPart = this.getEditor(i);
            if (editorPart instanceof BeanFlowGraphicalEditor && editorPart.isDirty()) {
                editorPart.doSave(monitor);
            }
            ++i;
        }
    }

    public void doSaveAs() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    private void addPage(IEditorPart editor, String title) {
        try {
            int index = this.addPage(editor, this.getEditorInput());
            this.setPageText(index, title);
        }
        catch (PartInitException e) {
            ErrorHandler.handle((WorkbenchPart)this, (Exception)((Object)e));
        }
    }

    private void insertPage(IEditorPart editor, String title) {
        try {
            this.addPage(0, editor, this.getEditorInput());
            this.setPageText(0, title);
        }
        catch (PartInitException e) {
            ErrorHandler.handle((WorkbenchPart)this, (Exception)((Object)e));
        }
    }

    private void refresh() {
        this.pageChanging = new AtomicBoolean(true);
        this.updateTextEditor();
        this.synchronizeWithTextEditor();
        this.pageChanging = new AtomicBoolean(false);
    }

    public void addFlow(String name) {
        this.flows.addFlow(name);
        this.refresh();
    }

    public void removeFlow(String name) {
        this.flows.removeFlow(name);
        this.refresh();
    }

    public IEditorPart getActiveEditorPart() {
        return this.getActiveEditor();
    }
}

