/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editor;

import java.util.EventObject;
import java.util.List;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.action.EditAction;
import jp.nimbus.ide.beanflow.action.ChangeTransactionAction;
import jp.nimbus.ide.beanflow.action.EditExtensionAction;
import jp.nimbus.ide.beanflow.action.EditTypeAction;
import jp.nimbus.ide.beanflow.action.EditValueAction;
import jp.nimbus.ide.beanflow.action.SelectFlowAction;
import jp.nimbus.ide.beanflow.action.SelectInvocationAction;
import jp.nimbus.ide.beanflow.action.SelectResourceAction;
import jp.nimbus.ide.beanflow.action.SelectServiceAction;
import jp.nimbus.ide.beanflow.action.SelectStaticInvocationAction;
import jp.nimbus.ide.beanflow.action.SelectStepAction;
import jp.nimbus.ide.beanflow.editor.BeanFlowEditor;
import jp.nimbus.ide.beanflow.editpart.ArgumentEditPart;
import jp.nimbus.ide.beanflow.editpart.AttributeEditPart;
import jp.nimbus.ide.beanflow.editpart.BeanFlowEditPartFactory;
import jp.nimbus.ide.beanflow.editpart.FlowEditPart;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.FlowInvocation;
import jp.nimbus.ide.beanflow.model.Junction;
import jp.nimbus.ide.beanflow.model.Loop;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Resource;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.dialog.InvocationSelectionDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class BeanFlowGraphicalEditor
extends GraphicalEditorWithFlyoutPalette {
    private Flow flow;
    private BeanFlowEditor beanFlowEditor;

    public BeanFlowGraphicalEditor(BeanFlowEditor beanFlowEditor, Flow flow) {
        this.beanFlowEditor = beanFlowEditor;
        this.flow = flow;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this){

            public void mouseDoubleClick(MouseEvent mouseEvent, EditPartViewer viewer) {
                super.mouseDoubleClick(mouseEvent, viewer);
                BeanFlowGraphicalEditor.this.handleDoubleClick();
            }
        });
    }

    public void setEditDomain(DefaultEditDomain editDomain) {
        super.setEditDomain(editDomain);
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.setEditPartFactory((EditPartFactory)new BeanFlowEditPartFactory());
        graphicalViewer.setContents((Object)this.flow);
        this.adjustContents();
        this.createContextMenu();
        this.createKeyHandler();
        this.getPalettePreferences().setPaletteState(4);
    }

    private void adjustContents() {
        FlowEditPart flowEditPart = (FlowEditPart)this.getGraphicalViewer().getContents();
        flowEditPart.adjustContents();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        PaletteViewerProvider paletteViewerProvider = new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.getPaletteViewerPreferences().setLayoutSetting(0);
            }
        };
        return paletteViewerProvider;
    }

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot paletteRoot = new PaletteRoot();
        PaletteGroup generalPaletteGroup = new PaletteGroup("General");
        SelectionToolEntry pointer = new SelectionToolEntry();
        generalPaletteGroup.add((PaletteEntry)pointer);
        MarqueeToolEntry marquee = new MarqueeToolEntry();
        generalPaletteGroup.add((PaletteEntry)marquee);
        paletteRoot.add((PaletteEntry)generalPaletteGroup);
        PaletteDrawer beanFlowPaletteGroup = new PaletteDrawer("BeanFlow");
        CreationToolEntry stepToolEntry = new CreationToolEntry("\u30b9\u30c6\u30c3\u30d7", "\u30d5\u30ed\u30fc\u306e\u5b9f\u884c\u5358\u4f4d\n\u958b\u59cb\u70b9\u3068\u7d42\u4e86\u70b9\u306e\u9593\u306b\u4f5c\u6210\u3057\u307e\u3059", (CreationFactory)new SimpleFactory(Step.class), Resources.getImageDescriptor("_icon_step"), Resources.getImageDescriptor("_icon_step"));
        beanFlowPaletteGroup.add((PaletteEntry)stepToolEntry);
        CreationToolEntry flowInvocationToolEntry = new CreationToolEntry("\u30d5\u30ed\u30fc\u547c\u3073\u51fa\u3057", "\u5916\u90e8\u30d5\u30ed\u30fc\u306e\u547c\u3073\u51fa\u3057\n\u958b\u59cb\u70b9\u3068\u7d42\u4e86\u70b9\u306e\u9593\u306b\u4f5c\u6210\u3057\u307e\u3059", (CreationFactory)new SimpleFactory(FlowInvocation.class), Resources.getImageDescriptor("_icon_flow_invocation"), Resources.getImageDescriptor("_icon_flow_invocation"));
        beanFlowPaletteGroup.add((PaletteEntry)flowInvocationToolEntry);
        CreationToolEntry resourceToolEntry = new CreationToolEntry("\u30ea\u30bd\u30fc\u30b9", "\u30d5\u30ed\u30fc\u5185\u3067\u4f7f\u7528\u3059\u308b\u30ea\u30bd\u30fc\u30b9\n\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30ea\u30bd\u30fc\u30b9\u3001\u30e1\u30c3\u30bb\u30fc\u30b8\u30ea\u30bd\u30fc\u30b9\u306a\u3069", (CreationFactory)new SimpleFactory(Resource.class), Resources.getImageDescriptor("_icon_resource"), Resources.getImageDescriptor("_icon_resource"));
        beanFlowPaletteGroup.add((PaletteEntry)resourceToolEntry);
        CreationToolEntry junctionToolEntry = new CreationToolEntry("\u6761\u4ef6\u5206\u5c90", "\u3042\u308b\u6761\u4ef6\u3092\u6e80\u305f\u3059\u3068\u304d\u5b9f\u884c\u3055\u308c\u308b\u30b9\u30c6\u30c3\u30d7\u306e\u96c6\u5408\n\u958b\u59cb\u70b9\u3068\u7d42\u4e86\u70b9\u306e\u9593\u306b\u4f5c\u6210\u3057\u307e\u3059", (CreationFactory)new SimpleFactory(Junction.class), Resources.getImageDescriptor("_icon_junction"), Resources.getImageDescriptor("_icon_junction"));
        beanFlowPaletteGroup.add((PaletteEntry)junctionToolEntry);
        CreationToolEntry loopToolEntry = new CreationToolEntry("\u7e70\u308a\u8fd4\u3057", "\u3042\u308b\u6761\u4ef6\u3092\u6e80\u305f\u3059\u3068\u304d\u7e70\u308a\u8fd4\u3055\u308c\u308b\u30b9\u30c6\u30c3\u30d7\u306e\u96c6\u5408\n\u958b\u59cb\u70b9\u3068\u7d42\u4e86\u70b9\u306e\u9593\u306b\u4f5c\u6210\u3057\u307e\u3059", (CreationFactory)new SimpleFactory(Loop.class), Resources.getImageDescriptor("_icon_loop"), Resources.getImageDescriptor("_icon_loop"));
        beanFlowPaletteGroup.add((PaletteEntry)loopToolEntry);
        paletteRoot.add((PaletteEntry)beanFlowPaletteGroup);
        paletteRoot.setDefaultEntry((ToolEntry)pointer);
        return paletteRoot;
    }

    protected void createActions() {
        super.createActions();
        Object action = new Action(){

            public void run() {
                InputDialog dialog = new InputDialog(BeanFlowGraphicalEditor.this.getSite().getShell(), "\u65b0\u898f\u30d5\u30ed\u30fc", "\u65b0\u898f\u30d5\u30ed\u30fc\u306e\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", null, new IInputValidator(){

                    public String isValid(String newText) {
                        return newText == null || newText.length() == 0 ? "\u5165\u529b\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002" : null;
                    }
                });
                if (dialog.open() == 0) {
                    BeanFlowGraphicalEditor.this.beanFlowEditor.addFlow(dialog.getValue());
                }
            }
        };
        action.setId("_add_flow");
        this.setupStackAction((IAction)action, Resources.getImageDescriptor("_icon_add"), "\u8ffd\u52a0", "\u30d5\u30ed\u30fc\u3092\u8ffd\u52a0\u3057\u307e\u3059");
        action = new Action(){

            public void run() {
                BeanFlowGraphicalEditor.this.beanFlowEditor.removeFlow(BeanFlowGraphicalEditor.this.flow.getName());
            }
        };
        action.setId("_remove_flow");
        this.setupStackAction((IAction)action, Resources.getImageDescriptor("_icon_remove"), "\u524a\u9664", "\u30d5\u30ed\u30fc\u3092\u524a\u9664\u3057\u307e\u3059");
        action = new EditValueAction((IWorkbenchPart)this, "_edit_values");
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_edit"), "\u7de8\u96c6", null);
        action = new EditTypeAction((IWorkbenchPart)this, "_reference_object");
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_object"), "\u30aa\u30d6\u30b8\u30a7\u30af\u30c8", "Java\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u53c2\u7167\u3057\u307e\u3059");
        action = new EditExtensionAction((IWorkbenchPart)this, "_reference_input", ReferenceType.Input);
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_input"), "\u5165\u529b", "\u30d5\u30ed\u30fc\u306e\u5165\u529b\u3092\u53c2\u7167\u3057\u307e\u3059");
        action = new SelectServiceAction((IWorkbenchPart)this, "_reference_service");
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_service_invocation"), "\u30b5\u30fc\u30d3\u30b9", "\u5b9a\u7fa9\u6e08\u307f\u306eNimbus\u30b5\u30fc\u30d3\u30b9\u3092\u53c2\u7167\u3057\u307e\u3059");
        action = new SelectResourceAction((IWorkbenchPart)this, "_reference_resource", this.flow);
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_resource"), "\u30ea\u30bd\u30fc\u30b9", null);
        action = new EditExtensionAction((IWorkbenchPart)this, "_reference_cursor", ReferenceType.Var);
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_cursor"), "\u30ab\u30fc\u30bd\u30eb", "\u7e70\u308a\u8fd4\u3057\u30bf\u30fc\u30b2\u30c3\u30c8\u306e\u73fe\u5728\u5024\u3092\u53c2\u7167\u3057\u307e\u3059");
        action = new SelectStepAction((IWorkbenchPart)this, "_reference_step", this.flow);
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_step_invocation"), "\u30b9\u30c6\u30c3\u30d7", null);
        action = new SelectFlowAction((IWorkbenchPart)this, "_reference_flow");
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_flow_invocation"), "\u30d5\u30ed\u30fc", null);
        action = new SelectInvocationAction((IWorkbenchPart)this, "_add_property", this.flow, InvocationSelectionDialog.InvocationType.Property);
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_property"), "\u30d7\u30ed\u30d1\u30c6\u30a3", "\u30bf\u30fc\u30b2\u30c3\u30c8\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u307e\u3059");
        action = new SelectInvocationAction((IWorkbenchPart)this, "_add_method", this.flow, InvocationSelectionDialog.InvocationType.Method);
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_invocation"), "\u30e1\u30bd\u30c3\u30c9", "\u30bf\u30fc\u30b2\u30c3\u30c8\u306e\u30e1\u30bd\u30c3\u30c9\u3092\u8a2d\u5b9a\u3057\u307e\u3059");
        action = new SelectStaticInvocationAction((IWorkbenchPart)this, "_add_static_method");
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_invocation"), "\u9759\u7684\u30e1\u30bd\u30c3\u30c9", "\u9759\u7684\u30e1\u30bd\u30c3\u30c9\u3092\u8a2d\u5b9a\u3057\u307e\u3059");
        action = new EditAction((IWorkbenchPart)this, "_add_argument");
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_injection"), "\u30d1\u30e9\u30e1\u30fc\u30bf", "\u53c2\u7167\u5148\u30d5\u30ed\u30fc\u306e\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u307e\u3059");
        action = new EditAction((IWorkbenchPart)this, "_add_result");
        this.setupSelectionAction((IAction)action, Resources.getImageDescriptor("_icon_output"), "\u51fa\u529b", "\u30b9\u30c6\u30c3\u30d7\u306e\u51fa\u529b\u3092\u8a2d\u5b9a\u3057\u307e\u3059");
        action = new ChangeTransactionAction((IWorkbenchPart)this, "_change_transaction_Required");
        this.setupSelectionAction((IAction)action, null, "\u958b\u59cb", "\u65e2\u5b58\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u7121\u3051\u308c\u3070\u65b0\u3057\u304f\u958b\u59cb\u3057\u307e\u3059\n\u3042\u308c\u3070\u4f55\u3082\u3057\u307e\u305b\u3093");
        action = new ChangeTransactionAction((IWorkbenchPart)this, "_change_transaction_RequiresNew");
        this.setupSelectionAction((IAction)action, null, "\u5f37\u5236\u958b\u59cb", "\u65e2\u5b58\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u7121\u3051\u308c\u3070\u65b0\u3057\u304f\u958b\u59cb\u3057\u307e\u3059\n\u3042\u308c\u3070\u4e2d\u65ad\u3057\u3066\u65b0\u3057\u304f\u958b\u59cb\u3057\u307e\u3059");
        action = new ChangeTransactionAction((IWorkbenchPart)this, "_change_transaction_Supports");
        this.setupSelectionAction((IAction)action, null, "\u8a31\u53ef", "\u65e2\u5b58\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u3042\u3063\u3066\u3082\u7121\u304f\u3066\u3082\u4f55\u3082\u3057\u307e\u305b\u3093");
        action = new ChangeTransactionAction((IWorkbenchPart)this, "_change_transaction_Mandatory");
        this.setupSelectionAction((IAction)action, null, "\u5fc5\u9808", "\u65e2\u5b58\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u7121\u3051\u308c\u3070\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059\n\u3042\u308c\u3070\u4f55\u3082\u3057\u307e\u305b\u3093");
        action = new ChangeTransactionAction((IWorkbenchPart)this, "_change_transaction_Never");
        this.setupSelectionAction((IAction)action, null, "\u4e0d\u8981", "\u65e2\u5b58\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u7121\u3051\u308c\u3070\u4f55\u3082\u3057\u307e\u305b\u3093\n\u3042\u308c\u3070\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059");
        action = new ChangeTransactionAction((IWorkbenchPart)this, "_change_transaction_NotSupported");
        this.setupSelectionAction((IAction)action, null, "\u4e2d\u65ad", "\u65e2\u5b58\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u7121\u3051\u308c\u3070\u4f55\u3082\u3057\u307e\u305b\u3093\n\u3042\u308c\u3070\u505c\u6b62\u3057\u307e\u3059");
    }

    private void setupStackAction(IAction action, ImageDescriptor icon, String label, String description) {
        action.setImageDescriptor(icon);
        action.setText(label);
        action.setToolTipText(description);
        this.getActionRegistry().registerAction(action);
        this.getStackActions().add(action.getId());
    }

    private void setupSelectionAction(IAction action, ImageDescriptor icon, String label, String description) {
        action.setImageDescriptor(icon);
        action.setText(label);
        action.setToolTipText(description);
        this.getActionRegistry().registerAction(action);
        this.getSelectionActions().add(action.getId());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof BeanFlowEditor) {
            IEditorPart editor = ((BeanFlowEditor)part).getActiveEditorPart();
            if (((Object)((Object)this)).equals(editor)) {
                this.updateActions(this.getSelectionActions());
            }
        } else {
            super.selectionChanged(part, selection);
        }
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add(this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        menuManager.add(this.getActionRegistry().getAction((Object)"_edit_values"));
        MenuManager targetMenuManager = new MenuManager("\u53c2\u7167");
        menuManager.add((IContributionItem)targetMenuManager);
        targetMenuManager.add(this.getActionRegistry().getAction((Object)"_reference_object"));
        targetMenuManager.add(this.getActionRegistry().getAction((Object)"_reference_input"));
        targetMenuManager.add(this.getActionRegistry().getAction((Object)"_reference_service"));
        targetMenuManager.add(this.getActionRegistry().getAction((Object)"_reference_resource"));
        targetMenuManager.add(this.getActionRegistry().getAction((Object)"_reference_cursor"));
        targetMenuManager.add(this.getActionRegistry().getAction((Object)"_reference_step"));
        targetMenuManager.add(this.getActionRegistry().getAction((Object)"_reference_flow"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getActionRegistry().getAction((Object)"_add_property"));
        menuManager.add(this.getActionRegistry().getAction((Object)"_add_method"));
        menuManager.add(this.getActionRegistry().getAction((Object)"_add_static_method"));
        menuManager.add(this.getActionRegistry().getAction((Object)"_add_argument"));
        menuManager.add(this.getActionRegistry().getAction((Object)"_add_result"));
        menuManager.add((IContributionItem)new Separator());
        MenuManager flowMenuManager = new MenuManager("\u30d5\u30ed\u30fc");
        menuManager.add((IContributionItem)flowMenuManager);
        flowMenuManager.add(this.getActionRegistry().getAction((Object)"_add_flow"));
        flowMenuManager.add(this.getActionRegistry().getAction((Object)"_remove_flow"));
        MenuManager transactionMenuManager = new MenuManager("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3", Resources.getImageDescriptor("_icon_transaction"), null);
        flowMenuManager.add((IContributionItem)transactionMenuManager);
        transactionMenuManager.add(this.getActionRegistry().getAction((Object)"_change_transaction_Required"));
        transactionMenuManager.add(this.getActionRegistry().getAction((Object)"_change_transaction_RequiresNew"));
        transactionMenuManager.add(this.getActionRegistry().getAction((Object)"_change_transaction_Supports"));
        transactionMenuManager.add(this.getActionRegistry().getAction((Object)"_change_transaction_Mandatory"));
        transactionMenuManager.add(this.getActionRegistry().getAction((Object)"_change_transaction_Never"));
        transactionMenuManager.add(this.getActionRegistry().getAction((Object)"_change_transaction_NotSupported"));
        this.getGraphicalViewer().setContextMenu(menuManager);
    }

    private void createKeyHandler() {
        KeyHandler keyHandler = new KeyHandler();
        keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        keyHandler.put(KeyStroke.getReleased((char)'\u001a', (int)122, (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()));
        keyHandler.put(KeyStroke.getReleased((char)'\u0019', (int)121, (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
        GraphicalViewerKeyHandler graphicalViewerKeyHandler = new GraphicalViewerKeyHandler(this.getGraphicalViewer());
        graphicalViewerKeyHandler.setParent(keyHandler);
        this.getGraphicalViewer().setKeyHandler((KeyHandler)graphicalViewerKeyHandler);
    }

    private void handleDoubleClick() {
        EditPart editPart;
        List editPartList = this.getGraphicalViewer().getSelectedEditParts();
        if (editPartList.size() == 1 && ((editPart = (EditPart)editPartList.get(0)) instanceof AttributeEditPart || editPart instanceof ArgumentEditPart)) {
            IAction action = this.getActionRegistry().getAction((Object)"_edit_values");
            action.run();
        }
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getCommandStack().markSaveLocation();
    }
}

