/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import jp.nimbus.ide.beanflow.editpart.Adjustable;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.ActivityContainer;
import jp.nimbus.ide.editpart.ConnectableModelEditPart;
import jp.nimbus.ide.editpart.ConnectableModelEditPolicy;
import jp.nimbus.ide.editpart.EditableLayoutEditPolicy;
import jp.nimbus.ide.figure.RoundedRectangle;
import jp.nimbus.ide.model.ConnectableModel;
import jp.nimbus.ide.model.Connection;
import jp.nimbus.ide.model.EditableModel;
import jp.nimbus.ide.util.WorkbenchUtil;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityContainerEditPart<Model extends Activity>
extends ConnectableModelEditPart
implements Adjustable {
    private static final int CONTENTS_PADDING = 8;
    private static final int ACTIVITY_SPACING = 24;
    private static final int DEFAULT_HEIGHT = 120;
    private static final int LABEL_HEIGHT = WorkbenchUtil.getShell().getFont().getFontData()[0].getHeight();

    protected IFigure createFigure() {
        Activity activity = (Activity)this.getModel();
        ActivityContainerFigure figure = this.createActivityContainerFigure(activity);
        this.adjustContents();
        return figure;
    }

    protected ActivityContainerFigure createActivityContainerFigure(Activity activity) {
        return new ActivityContainerFigure(activity);
    }

    @Override
    public void adjustContents() {
        for (EditPart editPart : this.getChildren()) {
            if (!(editPart instanceof Adjustable)) continue;
            ((Adjustable)editPart).adjustContents();
        }
        ActivityContainer activityContainer = (ActivityContainer)this.getModel();
        Rectangle baseBounds = ((Activity)((Object)activityContainer)).getBounds();
        Point baseLocation = baseBounds.getLocation();
        List<Activity> activityList = activityContainer.getActivities();
        EditableModel prevActivity = null;
        int baseWidth = baseBounds.width;
        int baseHeight = 16 + this.getLabelHeight();
        for (Activity activity : activityList) {
            if (prevActivity == null) {
                activity.setLocation(baseLocation.x, baseLocation.y + 8 + this.getLabelHeight());
            } else {
                Rectangle prevBounds = prevActivity.getBounds();
                activity.setLocation(baseLocation.x, prevBounds.y + prevBounds.height + 24);
                baseHeight += 24;
            }
            Rectangle bounds = activity.getBounds();
            if (bounds.width > baseWidth) {
                baseWidth = bounds.width;
            }
            baseHeight += bounds.height;
            prevActivity = activity;
        }
        int widthOffset = (baseWidth += 16) / 2;
        for (Activity activity : activityList) {
            Rectangle bounds = activity.getBounds();
            activity.setLocation(bounds.x + widthOffset - bounds.width / 2, bounds.y);
        }
        ((Activity)((Object)activityContainer)).setSize(baseWidth, baseHeight);
    }

    protected int getLabelHeight() {
        return LABEL_HEIGHT;
    }

    private void updateChildLocations(int dx, int dy) {
        ActivityContainer activityContainer = (ActivityContainer)this.getModel();
        List<Activity> activityList = activityContainer.getActivities();
        for (Activity activity : activityList) {
            Point location = activity.getBounds().getLocation();
            activity.setLocation(location.x + dx, location.y + dy);
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        ActivityContainer activityContainer = (ActivityContainer)this.getModel();
        children.addAll(activityContainer.getActivities());
        return children;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_bounds")) {
            this.refreshBounds();
            Point nb = ((Rectangle)event.getNewValue()).getLocation();
            Point ob = ((Rectangle)event.getOldValue()).getLocation();
            this.updateChildLocations(nb.x - ob.x, nb.y - ob.y);
        } else if (propertyName.equals("_source_connection")) {
            this.refreshSourceConnections();
        } else if (propertyName.equals("_target_connection")) {
            this.refreshTargetConnections();
        } else if (propertyName.equals("_step") || propertyName.equals("_junction") || propertyName.equals("_loop") || propertyName.equals("_flow_invocation")) {
            Point scrolledOffset = this.getScrolledOffset();
            org.eclipse.swt.graphics.Point cursorLocation = Display.getCurrent().getCursorLocation();
            cursorLocation = this.getViewer().getControl().toControl(cursorLocation);
            EditableModel editableModel = (EditableModel)event.getNewValue();
            if (editableModel != null) {
                editableModel.setLocation(cursorLocation.x + scrolledOffset.x, cursorLocation.y + scrolledOffset.y);
            }
            this.refreshChildren();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EditableLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)this.createActivityContainerEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ConnectableModelEditPolicy());
    }

    protected ActivityContainerEditPolicy createActivityContainerEditPolicy() {
        return new ActivityContainerEditPolicy();
    }

    @Override
    public Point getScrolledOffset() {
        Adjustable parent = (Adjustable)this.getParent();
        return parent.getScrolledOffset();
    }

    protected abstract Image getLabelImage();

    protected abstract String getLabelText(Model var1);

    protected abstract void addActivityContainer(ActivityContainer var1, Model var2, Activity var3);

    protected abstract void removeActivityContainer(ActivityContainer var1, Model var2);

    protected abstract String getValueFromContainer(Model var1);

    protected abstract void setValueToContainer(Model var1, String var2);

    protected class ActivityContainerEditPolicy
    extends ComponentEditPolicy {
        protected ActivityContainerEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            command = type.equals("_edit_values") ? this.createEditConditionCommand(request) : super.getCommand(request);
            return command;
        }

        protected Command createDeleteCommand(GroupRequest request) {
            ActivityContainer parentActivityContainer = (ActivityContainer)ActivityContainerEditPart.this.getParent().getModel();
            Activity activityContainer = (Activity)ActivityContainerEditPart.this.getModel();
            return new DeleteCommand(parentActivityContainer, activityContainer);
        }

        private Command createEditConditionCommand(Request request) {
            ActivityContainer activityContainer = (ActivityContainer)ActivityContainerEditPart.this.getModel();
            String expression = (String)request.getExtendedData().get("_data_expression");
            return new EditValueCommand(activityContainer, expression);
        }
    }

    protected class ActivityContainerFigure
    extends RoundedRectangle {
        protected static final int PADDING = 4;
        protected static final int SPACING = 4;
        protected Activity activityContainer;

        public ActivityContainerFigure(Activity activityContainer) {
            this.activityContainer = activityContainer;
            this.setLayoutManager((LayoutManager)new FreeformLayout());
            this.adjustBounds();
        }

        protected void drawContents(Graphics graphics) {
            Point location = this.getLocation().getCopy();
            location.x += 4;
            location.y += 4;
            Image image = ActivityContainerEditPart.this.getLabelImage();
            graphics.drawImage(image, location.x, location.y);
            String labelText = ActivityContainerEditPart.this.getLabelText(this.activityContainer);
            org.eclipse.swt.graphics.Rectangle imageBounds = image.getBounds();
            if (labelText != null) {
                graphics.drawText(labelText, location.x + imageBounds.width + 4, location.y);
            }
        }

        private void adjustBounds() {
            Rectangle bounds;
            int totalWidth = 0;
            Image image = ActivityContainerEditPart.this.getLabelImage();
            totalWidth = image.getBounds().width;
            String labelText = ActivityContainerEditPart.this.getLabelText(this.activityContainer);
            if (labelText != null) {
                Dimension textSize = FigureUtilities.getStringExtents((String)labelText, (Font)WorkbenchUtil.getShell().getFont());
                totalWidth += textSize.width;
            }
            if ((bounds = this.activityContainer.getBounds()) == null || totalWidth > bounds.width) {
                this.activityContainer.setSize(totalWidth, bounds != null && bounds.height > 0 ? bounds.height : 120);
            }
        }
    }

    protected class DeleteCommand
    extends Command {
        private ActivityContainer parentActivityContainer;
        private Activity activityContainer;
        private Connection sourceConnection;
        private Connection targetConnection;

        public DeleteCommand(ActivityContainer parentActivityContainer, Activity activityContainer) {
            this.parentActivityContainer = parentActivityContainer;
            this.activityContainer = activityContainer;
        }

        public void execute() {
            Connection sourceConnection = this.activityContainer.getSourceConnections().get(0);
            ConnectableModel target = sourceConnection.getTarget();
            sourceConnection.detachSource();
            sourceConnection.detachTarget();
            Connection targetConnection = this.activityContainer.getTargetConnections().get(0);
            targetConnection.detachTarget();
            targetConnection.setTarget(target);
            ActivityContainerEditPart.this.removeActivityContainer(this.parentActivityContainer, this.activityContainer);
        }

        public void undo() {
            Activity target = (Activity)this.targetConnection.getTarget();
            this.targetConnection.detachTarget();
            this.targetConnection.setTarget(this.activityContainer);
            this.sourceConnection.setSource(this.activityContainer);
            this.sourceConnection.setTarget(target);
            ActivityContainerEditPart.this.addActivityContainer(this.parentActivityContainer, this.activityContainer, target);
        }
    }

    private class EditValueCommand
    extends Command {
        private ActivityContainer activityContainer;
        private String expression;
        private String oldExpression;

        public EditValueCommand(ActivityContainer activityContainer, String expression) {
            this.activityContainer = activityContainer;
            this.expression = expression;
        }

        public void execute() {
            this.oldExpression = ActivityContainerEditPart.this.getValueFromContainer((Activity)((Object)this.activityContainer));
            ActivityContainerEditPart.this.setValueToContainer((Activity)((Object)this.activityContainer), this.expression);
        }

        public void undo() {
            ActivityContainerEditPart.this.setValueToContainer((Activity)((Object)this.activityContainer), this.oldExpression);
        }
    }
}

