/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.beanflow.action.StaticMethodExpression;
import jp.nimbus.ide.beanflow.figure.InvocationFigure;
import jp.nimbus.ide.beanflow.figure.StatementFigure;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.beanflow.model.Attribute;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.StaticInvocation;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.editpart.EditableModelEditPart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeEditPart
extends EditableModelEditPart {
    protected IFigure createFigure() {
        Attribute attribute = (Attribute)this.getModel();
        StatementFigure figure = new StatementFigure(attribute.getName(), Resources.getImage("_icon_property")){

            public void add(IFigure figure, Object constraint, int index) {
                if (figure instanceof InvocationFigure) {
                    super.add(figure, constraint, -1);
                    AttributeEditPart.this.updateParentBounds();
                } else {
                    super.add(figure, constraint, index);
                }
            }

            public void remove(IFigure figure) {
                super.remove(figure);
                if (figure instanceof InvocationFigure) {
                    AttributeEditPart.this.updateParentBounds();
                }
            }
        };
        figure.setValue(attribute);
        return figure;
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        Attribute attribute = (Attribute)this.getModel();
        if (attribute.getReferenceType() == ReferenceType.StaticInvoke) {
            children.add(attribute.getValue());
        }
        return children;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AttributeEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_bounds")) {
            this.refreshBounds();
        } else if (propertyName.equals("_value")) {
            Attribute attribute = (Attribute)this.getModel();
            StatementFigure figure = (StatementFigure)this.getFigure();
            figure.setValue(attribute);
            this.refreshChildren();
            this.updateParentBounds();
        }
    }

    private class AttributeEditPolicy
    extends ComponentEditPolicy {
        private AttributeEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            command = type.equals("_edit_values") || type.equals("_reference_object") || type.equals("_reference_input") || type.equals("_reference_service") || type.equals("_reference_resource") || type.equals("_reference_step") || type.equals("_reference_cursor") ? this.createEditValueCommand(request) : (type.equals("_add_static_method") ? this.createEditStaticInvocationCommand(request) : super.getCommand(request));
            return command;
        }

        protected Command getDeleteCommand(GroupRequest request) {
            Step step = (Step)AttributeEditPart.this.getParent().getModel();
            Attribute attribute = (Attribute)AttributeEditPart.this.getModel();
            return new DeleteCommand(step, attribute);
        }

        private Command createEditValueCommand(Request request) {
            Attribute attribute = (Attribute)AttributeEditPart.this.getModel();
            ReferenceType argumentType = (ReferenceType)((Object)request.getExtendedData().get("_data_type"));
            String expression = (String)request.getExtendedData().get("_data_expression");
            return new EditValueCommand(attribute, argumentType, expression);
        }

        private Command createEditStaticInvocationCommand(Request request) {
            Attribute attribute = (Attribute)AttributeEditPart.this.getModel();
            Map data = request.getExtendedData();
            StaticMethodExpression methodExpression = (StaticMethodExpression)data.get("_data_expression");
            StaticInvocation staticInvocation = null;
            if (methodExpression != null) {
                String type = methodExpression.getType();
                String methodName = methodExpression.getName();
                String[] parameterTypes = methodExpression.getParameterTypes();
                staticInvocation = attribute.createStaticInvocation();
                staticInvocation.setCode(type);
                staticInvocation.setName(methodName);
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                String[] stringArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterTypeExp = stringArray[n2];
                    Argument argument = staticInvocation.createArgument();
                    argument.setType(parameterTypeExp);
                    arguments.add(argument);
                    ++n2;
                }
                staticInvocation.setArguments(arguments);
            }
            return new EditValueCommand(attribute, ReferenceType.StaticInvoke, staticInvocation);
        }
    }

    private class DeleteCommand
    extends Command {
        private Step step;
        private Attribute attribute;

        public DeleteCommand(Step step, Attribute attribute) {
            this.step = step;
            this.attribute = attribute;
        }

        public void execute() {
            this.step.removeAttribute(this.attribute);
        }

        public void undo() {
            this.step.addAttribute(this.attribute);
        }
    }

    private class EditValueCommand
    extends Command {
        private Attribute attribute;
        private ReferenceType argumentType;
        private Object expression;
        private ReferenceType oldArgumentType;
        private Object oldExpression;

        public EditValueCommand(Attribute attribute, ReferenceType argumentType, Object expression) {
            this.attribute = attribute;
            this.argumentType = argumentType;
            this.expression = expression;
        }

        public void execute() {
            this.oldArgumentType = this.attribute.getReferenceType();
            this.oldExpression = this.attribute.getValue();
            this.attribute.setValue(this.argumentType, this.expression);
        }

        public void undo() {
            this.attribute.setValue(this.oldArgumentType, this.oldExpression);
        }
    }
}

