/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.beanflow.figure.StatementFigure;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.ActivityContainer;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.beanflow.model.FlowInvocation;
import jp.nimbus.ide.beanflow.util.FlowDescriptionManager;
import jp.nimbus.ide.editpart.ConnectableModelEditPart;
import jp.nimbus.ide.editpart.ConnectableModelEditPolicy;
import jp.nimbus.ide.figure.RoundedRectangle;
import jp.nimbus.ide.model.ConnectableModel;
import jp.nimbus.ide.model.Connection;
import jp.nimbus.ide.util.WorkbenchUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowInvocationEditPart
extends ConnectableModelEditPart {
    protected IFigure createFigure() {
        FlowInvocation flowInvocation = (FlowInvocation)this.getModel();
        FlowInvocationFigure figure = new FlowInvocationFigure(flowInvocation);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowInvocationLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new FlowInvocationEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ConnectableModelEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_bounds")) {
            this.refreshBounds();
        } else if (propertyName.equals("_source_connection")) {
            this.refreshSourceConnections();
        } else if (propertyName.equals("_target_connection")) {
            this.refreshTargetConnections();
        } else if (propertyName.equals("_step_name")) {
            FlowInvocationFigure figure = (FlowInvocationFigure)this.getFigure();
            figure.setName((String)event.getNewValue());
            this.updateModelBounds();
        } else if (propertyName.equals("_name")) {
            FlowInvocationFigure figure = (FlowInvocationFigure)this.getFigure();
            figure.setTarget((String)event.getNewValue());
            this.updateModelBounds();
        } else if (propertyName.equals("_arguments")) {
            this.refreshChildren();
            this.updateModelBounds();
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        FlowInvocation flowInvocation = (FlowInvocation)this.getModel();
        children.addAll(flowInvocation.getArguments());
        return children;
    }

    private class DeleteCommand
    extends Command {
        private ActivityContainer activityContainer;
        private FlowInvocation flowInvocation;
        private Connection sourceConnection;
        private Connection targetConnection;

        public DeleteCommand(ActivityContainer activityContainer, FlowInvocation flowInvocation) {
            this.activityContainer = activityContainer;
            this.flowInvocation = flowInvocation;
        }

        public void execute() {
            this.sourceConnection = this.flowInvocation.getSourceConnections().get(0);
            ConnectableModel target = this.sourceConnection.getTarget();
            this.sourceConnection.detachSource();
            this.sourceConnection.detachTarget();
            this.targetConnection = this.flowInvocation.getTargetConnections().get(0);
            this.targetConnection.detachTarget();
            this.targetConnection.setTarget(target);
            this.activityContainer.removeFlowInvocation(this.flowInvocation);
        }

        public void undo() {
            Activity target = (Activity)this.targetConnection.getTarget();
            this.targetConnection.detachTarget();
            this.targetConnection.setTarget(this.flowInvocation);
            this.sourceConnection.setSource(this.flowInvocation);
            this.sourceConnection.setTarget(target);
            this.activityContainer.addFlowInvocation(this.flowInvocation, target);
        }
    }

    private class EditArgumentCommand
    extends Command {
        private FlowInvocation flowInvocation;
        private Argument argument;

        public EditArgumentCommand(FlowInvocation flowInvocation) {
            this.flowInvocation = flowInvocation;
        }

        public void execute() {
            this.argument = this.flowInvocation.createArgument();
            this.flowInvocation.addArguments(this.argument);
        }

        public void undo() {
            this.flowInvocation.removeArgument(this.argument);
        }
    }

    private class EditFlowNameCommand
    extends Command {
        private FlowInvocation flowInvocation;
        private String flowName;
        private String oldFlowName;

        public EditFlowNameCommand(FlowInvocation flowInvocation, String flowName) {
            this.flowInvocation = flowInvocation;
            this.flowName = flowName;
        }

        public void execute() {
            this.oldFlowName = this.flowInvocation.getFlowName();
            this.flowInvocation.setFlowName(this.flowName);
        }

        public void undo() {
            this.flowInvocation.setFlowName(this.oldFlowName);
        }
    }

    private class EditNameCommand
    extends Command {
        private FlowInvocation flowInvocation;
        private String name;
        private String oldName;

        public EditNameCommand(FlowInvocation flowInvocation, String name) {
            this.flowInvocation = flowInvocation;
            this.name = name;
        }

        public void execute() {
            this.oldName = this.flowInvocation.getStepName();
            this.flowInvocation.setStepName(this.name);
        }

        public void undo() {
            this.flowInvocation.setStepName(this.oldName);
        }
    }

    private class FlowInvocationEditPolicy
    extends ComponentEditPolicy {
        private FlowInvocationEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            command = type.equals("_edit_values") ? this.createEditNameCommand(request) : (type.equals("_reference_flow") ? this.createEditFlowNameCommand(request) : (type.equals("_add_argument") ? this.createEditArgumentCommand(request) : super.getCommand(request)));
            return command;
        }

        private Command createEditNameCommand(Request request) {
            String name = (String)request.getExtendedData().get("_data_expression");
            FlowInvocation flowInvocation = (FlowInvocation)FlowInvocationEditPart.this.getModel();
            return new EditNameCommand(flowInvocation, name);
        }

        private Command createEditFlowNameCommand(Request request) {
            String name = (String)request.getExtendedData().get("_data_expression");
            FlowInvocation flowInvocation = (FlowInvocation)FlowInvocationEditPart.this.getModel();
            return new EditFlowNameCommand(flowInvocation, name);
        }

        private Command createEditArgumentCommand(Request request) {
            FlowInvocation flowInvocation = (FlowInvocation)FlowInvocationEditPart.this.getModel();
            return new EditArgumentCommand(flowInvocation);
        }

        protected Command getDeleteCommand(GroupRequest request) {
            ActivityContainer activityContainer = (ActivityContainer)FlowInvocationEditPart.this.getParent().getModel();
            FlowInvocation flowInvocation = (FlowInvocation)FlowInvocationEditPart.this.getModel();
            return new DeleteCommand(activityContainer, flowInvocation);
        }
    }

    private class FlowInvocationFigure
    extends RoundedRectangle {
        private Label nameLabel;
        private IFigure targetFigure;
        private IFigure invocationFigure;
        private Label targetLabel;

        public FlowInvocationFigure(FlowInvocation flowInvocation) {
            String stepName = flowInvocation.getStepName();
            String targetFlowName = flowInvocation.getFlowName();
            GridLayout layout = new GridLayout(1, false);
            this.setLayoutManager((LayoutManager)layout);
            Label label = new Label(stepName != null && stepName.length() > 0 ? stepName : targetFlowName);
            Font defaultFont = WorkbenchUtil.getShell().getFont();
            FontData defaultFontData = defaultFont.getFontData()[0];
            Font nameFont = new Font(defaultFont.getDevice(), defaultFontData.getName(), defaultFontData.getHeight(), 1);
            label.setFont(nameFont);
            this.nameLabel = label;
            this.add((IFigure)label);
            this.targetFigure = new Figure();
            layout = new GridLayout(1, false);
            layout.marginWidth = 4;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.targetFigure.setLayoutManager((LayoutManager)layout);
            this.add(this.targetFigure);
            this.invocationFigure = new Figure();
            layout = new GridLayout(1, false);
            layout.marginWidth = 16;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.invocationFigure.setLayoutManager((LayoutManager)layout);
            this.add(this.invocationFigure);
            this.setTarget(targetFlowName);
            Dimension dimension = this.getPreferredSize();
            flowInvocation.setSize(dimension.width, dimension.height);
        }

        public void setName(String name) {
            this.nameLabel.setText(name);
        }

        public void setTarget(String target) {
            if (target != null) {
                if (this.targetLabel == null) {
                    this.targetLabel = new Label();
                    this.targetLabel.setFont(WorkbenchUtil.getShell().getFont());
                    this.targetFigure.add((IFigure)this.targetLabel);
                }
                this.targetLabel.setIcon(Resources.getImage("_icon_flow_invocation"));
                this.targetLabel.setText(target);
                FlowDescriptionManager flowDescriptionManager = new FlowDescriptionManager(target);
                String flowDescription = null;
                try {
                    flowDescription = (String)flowDescriptionManager.search();
                }
                catch (CoreException e) {
                    throw new ParseException(e);
                }
                if (flowDescription != null) {
                    Label toolTipLabel = new Label(flowDescription);
                    this.targetLabel.setToolTip((IFigure)toolTipLabel);
                }
            } else if (this.targetLabel != null) {
                this.targetFigure.remove((IFigure)this.targetLabel);
            }
        }

        public void add(IFigure figure, Object constraint, int index) {
            if (figure instanceof StatementFigure) {
                this.invocationFigure.add(figure);
                FlowInvocationEditPart.this.updateModelBounds();
            } else {
                super.add(figure, constraint, index);
            }
        }

        public void remove(IFigure figure) {
            if (figure instanceof StatementFigure) {
                this.invocationFigure.remove(figure);
                FlowInvocationEditPart.this.updateModelBounds();
            } else {
                super.remove(figure);
            }
        }
    }

    private class FlowInvocationLayoutEditPolicy
    extends LayoutEditPolicy {
        private FlowInvocationLayoutEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new NonResizableEditPolicy();
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command getMoveChildrenCommand(Request request) {
            return null;
        }
    }
}

