/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.beanflow.editpart.ActivityContainerEditPart;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.ActivityContainer;
import jp.nimbus.ide.beanflow.model.Loop;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.util.WorkbenchUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopEditPart
extends ActivityContainerEditPart<Loop> {
    private static final int SPACING = 16;
    private static final int LABEL_HEIGHT = WorkbenchUtil.getShell().getFont().getFontData()[0].getHeight();

    @Override
    protected ActivityContainerEditPart.ActivityContainerFigure createActivityContainerFigure(Activity activity) {
        Loop loop = (Loop)this.getModel();
        LoopFigure loopFigure = new LoopFigure(activity);
        loopFigure.setTarget(loop.getTarget());
        return loopFigure;
    }

    @Override
    protected ActivityContainerEditPart.ActivityContainerEditPolicy createActivityContainerEditPolicy() {
        return new LoopEditPolicy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_cursor")) {
            IFigure figure = this.getFigure();
            figure.repaint();
        } else if (propertyName.equals("_target")) {
            LoopFigure figure = (LoopFigure)this.getFigure();
            figure.setTarget((Target)event.getNewValue());
            figure.repaint();
        } else {
            super.propertyChange(event);
        }
    }

    @Override
    protected Image getLabelImage() {
        return Resources.getImage("_icon_loop");
    }

    @Override
    protected String getLabelText(Loop activityContainer) {
        return activityContainer.getCursor();
    }

    @Override
    protected void addActivityContainer(ActivityContainer parentActivityContainer, Loop activityContainer, Activity target) {
        parentActivityContainer.addLoop(activityContainer, target);
    }

    @Override
    protected void removeActivityContainer(ActivityContainer parentActivityContainer, Loop activityContainer) {
        parentActivityContainer.removeLoop(activityContainer);
    }

    @Override
    protected String getValueFromContainer(Loop activityContainer) {
        return activityContainer.getCursor();
    }

    @Override
    protected void setValueToContainer(Loop activityContainer, String expression) {
        activityContainer.setCursor(expression);
    }

    private int getBaseLabelHeight() {
        return super.getLabelHeight();
    }

    @Override
    protected int getLabelHeight() {
        return this.getBaseLabelHeight() + 16 + LABEL_HEIGHT;
    }

    private class EditTargetCommand
    extends Command {
        private Loop loop;
        private ReferenceType type;
        private String expression;
        private Target oldTarget;

        public EditTargetCommand(Loop loop, ReferenceType type, String expression) {
            this.loop = loop;
            this.type = type;
            this.expression = expression;
        }

        public void execute() {
            this.oldTarget = this.loop.getTarget();
            Target target = this.loop.createTarget();
            target.setExpression(this.type, this.expression);
            this.loop.setTarget(target);
        }

        public void undo() {
            this.loop.setTarget(this.oldTarget);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LoopEditPolicy
    extends ActivityContainerEditPart.ActivityContainerEditPolicy {
        protected LoopEditPolicy() {
        }

        @Override
        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            command = type.equals("_reference_object") || type.equals("_reference_service") || type.equals("_reference_resource") || type.equals("_reference_step") ? this.createEditTargetCommand(request) : super.getCommand(request);
            return command;
        }

        private Command createEditTargetCommand(Request request) {
            ReferenceType type = (ReferenceType)((Object)request.getExtendedData().get("_data_type"));
            String expression = (String)request.getExtendedData().get("_data_expression");
            Loop loop = (Loop)LoopEditPart.this.getModel();
            return new EditTargetCommand(loop, type, expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LoopFigure
    extends ActivityContainerEditPart.ActivityContainerFigure {
        private static final int H_PADDING = 16;
        private static final int V_PADDING = 8;
        private Target target;

        public LoopFigure(Activity activityContainer) {
            super(activityContainer);
        }

        @Override
        protected void drawContents(Graphics graphics) {
            super.drawContents(graphics);
            if (this.target != null) {
                Point location = this.getLocation().getCopy();
                location.x += 16;
                location.y = location.y + 4 + LoopEditPart.this.getBaseLabelHeight() + 8;
                Image image = this.target.getReferenceType().getImage();
                graphics.drawImage(image, location.x, location.y);
                String labelText = this.target.getExpression();
                Rectangle imageBounds = image.getBounds();
                if (labelText != null) {
                    graphics.drawText(labelText, location.x + imageBounds.width + 4, location.y);
                }
            }
        }

        public void setTarget(Target target) {
            this.target = target;
        }
    }
}

