/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.figure;

import jp.nimbus.ide.Resources;
import jp.nimbus.ide.beanflow.model.Parameter;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.util.WorkbenchUtil;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.graphics.Image;

public class StatementFigure
extends Figure {
    private static final int VALUE_LENGTH_LIMIT = 100;
    private static final String VALUE_RETURN = "\n";
    private Label nameLabel;
    private Label injectedImage;
    private Figure valueLabel;
    private boolean shortenedValue = true;

    public StatementFigure() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 0;
        this.setLayoutManager((LayoutManager)layout);
        this.createInjectedImage();
    }

    public StatementFigure(String name, Image image) {
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 0;
        this.setLayoutManager((LayoutManager)layout);
        this.nameLabel = new Label(name, image);
        this.nameLabel.setFont(WorkbenchUtil.getShell().getFont());
        this.add((IFigure)this.nameLabel);
        this.setConstraint((IFigure)this.nameLabel, new GridData(2));
    }

    public void setShortenedValue(boolean shortenedValue) {
        this.shortenedValue = shortenedValue;
    }

    public void setName(String name) {
        if (this.nameLabel != null) {
            this.nameLabel.setText(name);
        }
    }

    public void setValue(String value) {
        this.setValue(null, value);
    }

    public void setValue(Parameter parameter) {
        ReferenceType referenceType = parameter.getReferenceType();
        if (referenceType != ReferenceType.StaticInvoke) {
            this.setValue(referenceType.getImage(), (String)parameter.getValue());
        } else {
            this.cleanUpValue();
        }
    }

    protected void setValue(Image referenceImage, String value) {
        if (referenceImage == null && value == null) {
            return;
        }
        this.cleanUpValue();
        this.valueLabel = !this.shortenedValue || value.length() < 100 && !value.contains(VALUE_RETURN) ? (value != null ? new Label(value, referenceImage) : new Label(referenceImage)) : new Label(Resources.getImage("_icon_text"));
        this.add((IFigure)this.valueLabel);
    }

    private void cleanUpValue() {
        this.createInjectedImage();
        if (this.valueLabel != null) {
            this.remove((IFigure)this.valueLabel);
        }
    }

    private void createInjectedImage() {
        if (this.injectedImage == null) {
            this.injectedImage = new Label(Resources.getImage("_icon_injection"));
            this.add((IFigure)this.injectedImage);
            this.setConstraint((IFigure)this.injectedImage, new GridData(2));
        }
    }
}

