/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.ActivityCollection;
import jp.nimbus.ide.beanflow.model.Resource;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flow
extends ActivityCollection {
    private static final String TAG_TRANSACTION = "transaction";
    private static final String TAG_RESOURCE = "resource";
    public static final String RESOURCE = "_resource";
    private static XPathExpression nameXPath;
    private static XPathExpression transactionXPath;
    private List<Resource> resourceList;

    static {
        try {
            nameXPath = Activator.xPath.compile("@name");
            transactionXPath = Activator.xPath.compile("@transaction");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Flow(Element node) {
        super(node, true, null);
        this.createResourceList();
    }

    private void createResourceList() {
        this.resourceList = new ArrayList<Resource>();
        NodeList nodeList = this.node.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && (element = (Element)childNode).getTagName().equals(TAG_RESOURCE)) {
                Resource resource = new Resource(element);
                this.resourceList.add(resource);
            }
            ++i;
        }
    }

    public String getName() {
        String name = null;
        try {
            name = (String)nameXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            new ParseException(e);
        }
        return name;
    }

    public Transaction getTransaction() {
        Transaction transaction = Transaction.Supports;
        String transactionExp = null;
        try {
            transactionExp = (String)transactionXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        if (transactionExp != null) {
            transaction = Transaction.valueOf(transactionExp);
        }
        return transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.node.setAttribute(TAG_TRANSACTION, transaction.toString());
    }

    public List<Resource> getResources() {
        return this.resourceList;
    }

    public Resource createResource() {
        Resource resource = new Resource(DocumentUtil.createElement(this.node, TAG_RESOURCE));
        resource.setName(this.createNewResourceName());
        resource.setTransactionControl(true);
        return resource;
    }

    public void addResource(Resource resource) {
        Node refNode = null;
        if (this.resourceList.size() > 0) {
            Element prevNode = this.resourceList.get(this.resourceList.size() - 1).getNode();
            refNode = prevNode.getNextSibling();
        }
        this.node.insertBefore(resource.getNode(), refNode);
        this.resourceList.add(resource);
        this.firePropertyChange(RESOURCE, null, resource);
    }

    public void removeResource(Resource resource) {
        this.resourceList.remove(resource);
        Node childNode = null;
        try {
            childNode = (Node)Activator.xPath.evaluate("resource[@name='" + resource.getName() + "']", this.node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.node.removeChild(childNode);
        this.firePropertyChange(RESOURCE, null, resource);
    }

    private String createNewResourceName() {
        int sequence = 0;
        for (Resource exist : this.getResources()) {
            String suffix;
            String existName = exist.getName();
            if (!existName.startsWith("Resource") || (suffix = existName.substring("Resource".length())) == null) continue;
            int seq = -1;
            try {
                seq = Integer.parseInt(suffix);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (seq <= sequence) continue;
            sequence = seq;
        }
        return "Resource" + String.valueOf(++sequence);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transaction {
        Required,
        RequiresNew,
        Supports,
        Mandatory,
        Never,
        NotSupported;

    }
}

