/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.model.StorageModel;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowCollection
extends StorageModel {
    private static final String TAG_FLOWS = "flows";
    private static final String TAG_FLOW = "flow";
    private Element node;

    public FlowCollection(FileEditorInput editorInput) {
        super(editorInput);
    }

    @Override
    public void read(InputStream inputStream) throws Exception {
        super.read(inputStream);
        Element element = this.document.getDocumentElement();
        if (!element.getTagName().equals(TAG_FLOWS)) {
            throw new ParseException("\u4e0d\u6b63\u306aXML\u3067\u3059\u3002");
        }
        this.node = element;
    }

    public List<Flow> getFlows() {
        ArrayList<Flow> flowList = new ArrayList<Flow>();
        NodeList nodeList = this.node.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                flowList.add(new Flow((Element)node));
            }
            ++i;
        }
        return flowList;
    }

    public void addFlow(String name) {
        Element element = this.document.createElement(TAG_FLOW);
        element.setAttribute("name", name);
        this.node.appendChild(element);
    }

    public void removeFlow(String name) {
        Node removedNode = null;
        try {
            removedNode = (Node)Activator.xPath.evaluate("/flows/flow[@name=\"" + name + "\"]", this.node, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ParseException("\u4e0d\u6b63\u306aXML\u3067\u3059\u3002");
        }
        if (this.node != null) {
            this.node.removeChild(removedNode);
        }
    }
}

