/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.model.ElementModel;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowInvocation
extends Activity
implements ElementModel {
    private static final String TAG_ARGUMENT = "argument";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_STEP_NAME = "stepname";
    public static final String FLOW_NAME = "_name";
    public static final String STEP_NAME = "_step_name";
    public static final String ARGUMENT = "_arguments";
    private static XPathExpression nameXPath;
    private static XPathExpression stepNameXPath;
    private Element node;
    private List<Argument> argumentList;

    static {
        try {
            nameXPath = Activator.xPath.compile("@name");
            stepNameXPath = Activator.xPath.compile("@stepname");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public FlowInvocation(Element node) {
        this.node = node;
        this.createArgumentList();
    }

    private void createArgumentList() {
        this.argumentList = new ArrayList<Argument>();
        NodeList nodeList = this.node.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && (element = (Element)childNode).getTagName().equals(TAG_ARGUMENT)) {
                Argument argument = new Argument(element);
                this.argumentList.add(argument);
            }
            ++i;
        }
    }

    @Override
    public Element getNode() {
        return this.node;
    }

    public String getFlowName() {
        String flowName = null;
        try {
            flowName = (String)nameXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        return flowName;
    }

    public void setFlowName(String flowName) {
        if (flowName != null) {
            this.node.setAttribute(ATTR_NAME, flowName);
        } else {
            this.node.removeAttribute(ATTR_NAME);
        }
        this.firePropertyChange(FLOW_NAME, null, flowName);
    }

    public String getStepName() {
        String stepName = null;
        try {
            stepName = (String)stepNameXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        return stepName;
    }

    public void setStepName(String stepName) {
        if (stepName != null) {
            this.node.setAttribute(ATTR_STEP_NAME, stepName);
        } else {
            this.node.removeAttribute(ATTR_STEP_NAME);
        }
        this.firePropertyChange(STEP_NAME, null, stepName);
    }

    public List<Argument> getArguments() {
        return this.argumentList;
    }

    public Argument createArgument() {
        Element element = DocumentUtil.createElement(this.node, TAG_ARGUMENT);
        return new Argument(element);
    }

    public void addArguments(Argument argument) {
        this.node.appendChild(argument.getNode());
        this.argumentList.add(argument);
        this.firePropertyChange(ARGUMENT, null, argument);
    }

    public void removeArgument(Argument argument) {
        this.node.removeChild(argument.getNode());
        this.argumentList.remove(argument);
        this.firePropertyChange(ARGUMENT, argument, null);
    }
}

