/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.ActivityCollection;
import jp.nimbus.ide.beanflow.model.ActivityCollectionAdaptor;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.model.ElementModel;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Loop
extends ActivityCollectionAdaptor
implements ElementModel {
    private static final String TAG_TARGET = "target";
    private static final String ATTR_VAR = "var";
    public static final String CURSOR = "_cursor";
    public static final String TARGET = "_target";
    private static XPathExpression varXPath;
    private static XPathExpression targetXPath;
    private Element node;

    static {
        try {
            varXPath = Activator.xPath.compile("@var");
            targetXPath = Activator.xPath.compile(TAG_TARGET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Loop(Element node, ActivityCollection parent) {
        super(node, parent);
        this.node = node;
    }

    public Element getNode() {
        return this.node;
    }

    public String getCursor() {
        String cursor = null;
        try {
            cursor = (String)varXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        return cursor;
    }

    public void setCursor(String cursor) {
        this.node.setAttribute(ATTR_VAR, cursor);
        this.firePropertyChange(CURSOR, null, cursor);
    }

    public Target getTarget() {
        Node targetNode = null;
        try {
            targetNode = (Node)targetXPath.evaluate(this.node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            new ParseException(e);
        }
        Target target = null;
        if (targetNode != null) {
            target = new Target((Element)targetNode);
        }
        return target;
    }

    public Target createTarget() {
        Element childNode = this.node.getOwnerDocument().createElement(TAG_TARGET);
        return new Target(childNode);
    }

    public void setTarget(Target target) {
        DocumentUtil.removeChildren(this.node);
        if (target != null) {
            this.node.appendChild(target.getNode());
            this.firePropertyChange(TARGET, null, target);
        }
    }
}

