/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.Reference;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.StaticInvocation;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Parameter
extends Reference {
    private static final String TAG_STATIC_INVOKE = "static-invoke";
    private static final String ATTR_TYPE = "type";
    public static final String TYPE = "_type";
    public static final String VALUE = "_value";
    private static XPathExpression typeXPath;
    private Object value;

    static {
        try {
            typeXPath = Activator.xPath.compile("@type");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Parameter(Element node) {
        super(node);
        this.setupValue();
    }

    public String getType() {
        String type = null;
        try {
            type = (String)typeXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        return type;
    }

    public void setType(String type) {
        this.node.setAttribute(ATTR_TYPE, type);
        this.firePropertyChange(TYPE, null, type);
    }

    private void setupValue() {
        Element child;
        Text text;
        ReferenceType referenceType = this.getReferenceType();
        if (referenceType == ReferenceType.Text) {
            Text text2 = DocumentUtil.getFirstTextNode(this.node);
            this.value = text2.getNodeValue();
        } else if (referenceType == ReferenceType.StaticInvoke) {
            Element childNode = DocumentUtil.getFirstElement(this.node);
            this.value = new StaticInvocation(childNode);
        } else if (referenceType != ReferenceType.Unknown && (text = DocumentUtil.getFirstTextNode(child = DocumentUtil.getFirstElement(this.node))) != null) {
            this.value = text.getNodeValue();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(ReferenceType referenceType, Object value) {
        DocumentUtil.removeChildren(this.node);
        if (referenceType == ReferenceType.Text) {
            String valueExp = (String)value;
            Text text = this.node.getOwnerDocument().createTextNode(valueExp);
            this.node.appendChild(text);
        } else if (referenceType == ReferenceType.StaticInvoke) {
            StaticInvocation valueExp = (StaticInvocation)value;
            this.node.appendChild(valueExp.getNode());
        } else if (referenceType != ReferenceType.Unknown) {
            String valueExp = (String)value;
            Element child = DocumentUtil.createElement(this.node, referenceType.getExpression());
            if (valueExp != null) {
                Text text = this.node.getOwnerDocument().createTextNode(valueExp);
                child.appendChild(text);
            }
            this.node.appendChild(child);
        }
        this.value = value;
        this.firePropertyChange(VALUE, null, value);
    }

    public StaticInvocation createStaticInvocation() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_STATIC_INVOKE);
        return new StaticInvocation(childNode);
    }
}

