/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.model.EditableModel;
import jp.nimbus.ide.model.ElementModel;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Reference
extends EditableModel
implements ElementModel {
    protected Element node;

    public Reference(Element node) {
        this.node = node;
    }

    public Element getNode() {
        return this.node;
    }

    public ReferenceType getReferenceType() {
        ReferenceType referenceType = ReferenceType.Unknown;
        Element child = DocumentUtil.getFirstElement(this.node);
        if (child == null) {
            Text text = DocumentUtil.getFirstTextNode(this.node);
            if (text != null) {
                referenceType = ReferenceType.Text;
            }
        } else {
            Element element = DocumentUtil.getFirstElement(this.node);
            if (element != null) {
                String nodeName = element.getNodeName();
                if (ReferenceType.Input.equals(nodeName)) {
                    referenceType = ReferenceType.Input;
                } else if (ReferenceType.Object.equals(nodeName)) {
                    referenceType = ReferenceType.Object;
                } else if (ReferenceType.ServiceRef.equals(nodeName)) {
                    referenceType = ReferenceType.ServiceRef;
                } else if (ReferenceType.ResourceRef.equals(nodeName)) {
                    referenceType = ReferenceType.ResourceRef;
                } else if (ReferenceType.StepRef.equals(nodeName)) {
                    referenceType = ReferenceType.StepRef;
                } else if (ReferenceType.StaticFieldRef.equals(nodeName)) {
                    referenceType = ReferenceType.StaticFieldRef;
                } else if (ReferenceType.StaticInvoke.equals(nodeName)) {
                    referenceType = ReferenceType.StaticInvoke;
                } else if (ReferenceType.Var.equals(nodeName)) {
                    referenceType = ReferenceType.Var;
                } else if (ReferenceType.Expression.equals(nodeName)) {
                    referenceType = ReferenceType.Expression;
                } else if (ReferenceType.This.equals(nodeName)) {
                    referenceType = ReferenceType.This;
                }
            }
        }
        return referenceType;
    }
}

