/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.Attribute;
import jp.nimbus.ide.beanflow.model.Invocation;
import jp.nimbus.ide.beanflow.model.Result;
import jp.nimbus.ide.beanflow.model.StaticInvocation;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.model.ElementModel;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Step
extends Activity
implements ElementModel {
    public static final String DEFAULT_NAME = "Step";
    private static final String TAG_TARGET = "target";
    private static final String TAG_FIELD = "field";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String TAG_INVOKE = "invoke";
    private static final String TAG_STATIC_INVOKE = "static-invoke";
    private static final String TAG_RESULT = "result";
    private static final String ATTR_NAME = "name";
    public static final String NAME = "_name";
    public static final String TARGET = "_target";
    public static final String ATTRIBUTE = "_attribute";
    public static final String INVOCATION = "_invocation";
    public static final String STATIC_INVOCATION = "_static_invocation";
    public static final String RESULT = "_result";
    private static XPathExpression nameXPath;
    private static XPathExpression targetXPath;
    private static XPathExpression resultXPath;
    private Element node;

    static {
        try {
            nameXPath = Activator.xPath.compile("@name");
            targetXPath = Activator.xPath.compile(TAG_TARGET);
            resultXPath = Activator.xPath.compile(TAG_RESULT);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Step(Element node) {
        this.node = node;
    }

    @Override
    public Element getNode() {
        return this.node;
    }

    public String getName() {
        String name = null;
        try {
            name = (String)nameXPath.evaluate(this.node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            new ParseException(e);
        }
        return name;
    }

    public void setName(String name) {
        if (name != null) {
            this.node.setAttribute(ATTR_NAME, name);
        } else {
            this.node.removeAttribute(ATTR_NAME);
        }
        this.firePropertyChange(NAME, null, name);
    }

    public Target getTarget() {
        Node targetNode = null;
        try {
            targetNode = (Node)targetXPath.evaluate(this.node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            new ParseException(e);
        }
        Target target = null;
        if (targetNode != null) {
            target = new Target((Element)targetNode);
        }
        return target;
    }

    public Target createTarget() {
        Element childNode = this.node.getOwnerDocument().createElement(TAG_TARGET);
        return new Target(childNode);
    }

    public void setTarget(Target target) {
        DocumentUtil.removeChildren(this.node);
        if (target != null) {
            this.node.appendChild(target.getNode());
            this.firePropertyChange(TARGET, null, target);
        }
    }

    public List<Object> getInvocationList() {
        ArrayList<Object> invocationList = new ArrayList<Object>();
        NodeList children = this.node.getChildNodes();
        int childrenSize = children.getLength();
        int i = 0;
        while (i < childrenSize) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1) {
                Element childElement = (Element)childNode;
                String nodeName = childElement.getNodeName();
                if (nodeName.equals(TAG_ATTRIBUTE) || nodeName.equals(TAG_FIELD)) {
                    invocationList.add(new Attribute(childElement));
                } else if (nodeName.equals(TAG_INVOKE)) {
                    invocationList.add(new Invocation(childElement));
                } else if (nodeName.equals(TAG_STATIC_INVOKE)) {
                    invocationList.add(new StaticInvocation(childElement));
                }
            }
            ++i;
        }
        return invocationList;
    }

    public Attribute createAttribute() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_ATTRIBUTE);
        return new Attribute(childNode);
    }

    public void addAttribute(Attribute attribute) {
        this.node.appendChild(attribute.getNode());
        this.firePropertyChange(ATTRIBUTE, null, attribute);
    }

    public void removeAttribute(Attribute attribute) {
        this.node.removeChild(attribute.getNode());
        this.firePropertyChange(ATTRIBUTE, attribute, null);
    }

    public Invocation createInvocation() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_INVOKE);
        return new Invocation(childNode);
    }

    public void addInvocation(Invocation invocation) {
        this.node.appendChild(invocation.getNode());
        this.firePropertyChange(INVOCATION, null, invocation);
    }

    public void removeInvocation(Invocation invocation) {
        this.node.removeChild(invocation.getNode());
        this.firePropertyChange(INVOCATION, invocation, null);
    }

    public StaticInvocation createStaticInvocation() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_STATIC_INVOKE);
        return new StaticInvocation(childNode);
    }

    public void addStaticInvocation(StaticInvocation staticInvocation) {
        this.node.appendChild(staticInvocation.getNode());
        this.firePropertyChange(STATIC_INVOCATION, null, staticInvocation);
    }

    public void removeStaticInvocation(StaticInvocation staticInvocation) {
        this.node.removeChild(staticInvocation.getNode());
        this.firePropertyChange(STATIC_INVOCATION, staticInvocation, null);
    }

    public Result createResult() {
        Element childNode = DocumentUtil.createElement(this.node, TAG_RESULT);
        return new Result(childNode);
    }

    public Result getResult() {
        Result result = null;
        Element element = null;
        try {
            element = (Element)resultXPath.evaluate(this.node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        if (element != null) {
            result = new Result(element);
        }
        return result;
    }

    public void setResult(Result result) {
        Element element = null;
        try {
            element = (Element)resultXPath.evaluate(this.node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        if (element != null) {
            this.node.removeChild(element);
        }
        this.node.appendChild(result.getNode());
        this.firePropertyChange(RESULT, null, result);
    }

    public void removeResult(Result result) {
        this.node.removeChild(result.getNode());
        this.firePropertyChange(RESULT, result, null);
    }

    public String toString() {
        return this.getName();
    }
}

