/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ParseException;
import jp.nimbus.ide.beanflow.model.Reference;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;

public class Target
extends Reference {
    private static final String ATTR_CODE = "code";
    private static XPathExpression expressionXPath;
    private static XPathExpression codeXPath;

    static {
        try {
            expressionXPath = Activator.xPath.compile("text()");
            codeXPath = Activator.xPath.compile("@code");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Target(Element node) {
        super(node);
    }

    public String getExpression() {
        String expression = null;
        Element childNode = DocumentUtil.getFirstElement(this.node);
        try {
            expression = this.getReferenceType() == ReferenceType.Object ? (String)codeXPath.evaluate(childNode, XPathConstants.STRING) : (String)expressionXPath.evaluate(childNode, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        return expression;
    }

    public void setExpression(ReferenceType type, String expression) {
        DocumentUtil.removeFirstElement(this.node);
        Element element = DocumentUtil.createElement(this.node, type.getExpression());
        if (type == ReferenceType.Object) {
            element.setAttribute(ATTR_CODE, expression);
        } else {
            element.setTextContent(expression);
        }
        this.node.appendChild(element);
    }
}

