/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.util;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ProjectHandler;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.FlowInvocation;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Result;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFlowUtil {
    private static final String BEANFLOW_FILE_EXTENSION = "xml";
    private static final String BEANFLOW_ROOT_ELEMENT = "flows";
    private static final String ATTR_NAME = "name";
    private static XPathExpression flowXPath;

    static {
        try {
            flowXPath = Activator.xPath.compile("flow");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Element> searchAllFlowNames() throws CoreException {
        TreeMap<String, Element> flowNameList = new TreeMap<String, Element>();
        IJavaProject javaProject = ProjectHandler.getCurrentProject();
        IResource[] resources = (IResource[])javaProject.getNonJavaResources();
        BeanFlowUtil.searchAllFlowNames(flowNameList, resources);
        return flowNameList;
    }

    private static void searchAllFlowNames(Map<String, Element> flowNameList, IResource[] resources) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String fileExtension = file.getFileExtension();
                if (BEANFLOW_FILE_EXTENSION.equals(fileExtension)) {
                    Element rootElement;
                    Document document = null;
                    try {
                        document = DocumentUtil.read(file.getContents());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (document != null && (rootElement = document.getDocumentElement()) != null && rootElement.getNodeName().equals(BEANFLOW_ROOT_ELEMENT)) {
                        NodeList nodeList = null;
                        try {
                            nodeList = (NodeList)flowXPath.evaluate(rootElement, XPathConstants.NODESET);
                        }
                        catch (XPathExpressionException e) {
                            e.printStackTrace();
                        }
                        if (nodeList != null) {
                            int nodeSize = nodeList.getLength();
                            int i = 0;
                            while (i < nodeSize) {
                                Element element = (Element)nodeList.item(i);
                                flowNameList.put(element.getAttribute(ATTR_NAME), element);
                                ++i;
                            }
                        }
                    }
                }
            } else if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IResource[] innerResources = folder.members(false);
                BeanFlowUtil.searchAllFlowNames(flowNameList, innerResources);
            }
            ++n2;
        }
    }

    public static String searchObjectTarget(Flow flow, String stepName) {
        String expression = null;
        Activity activity = flow.searchActivity(stepName);
        if (activity != null) {
            if (activity instanceof Step) {
                ReferenceType resultRefType;
                Step step = (Step)activity;
                Result result = step.getResult();
                if (result != null && (resultRefType = result.getReferenceType()) == ReferenceType.This) {
                    Target target = step.getTarget();
                    ReferenceType targetRefType = target.getReferenceType();
                    if (targetRefType == ReferenceType.Object) {
                        expression = target.getExpression();
                    } else if (targetRefType == ReferenceType.StepRef) {
                        expression = BeanFlowUtil.searchObjectTarget(flow, target.getExpression());
                    }
                }
            } else {
                boolean cfr_ignored_0 = activity instanceof FlowInvocation;
            }
        }
        return expression;
    }
}

