/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.dialog;

import jp.nimbus.ide.Resources;
import jp.nimbus.ide.util.DialogUtil;
import jp.nimbus.ide.util.TypeUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class StaticInvocationSelectionDialog
extends ElementTreeSelectionDialog {
    private static final int CHAR_WIDTH = 30;
    private static final int CHAR_HEIGHT = 18;
    private static final String TITLE = "\u547c\u51fa\u3057\u5bfe\u8c61\u306e\u9078\u629e";
    private static final String MESSAGE = "\u547c\u51fa\u3057\u5bfe\u8c61\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final String ERROR_INPUT = "\u9759\u7684\u30e1\u30bd\u30c3\u30c9\u3092\u6301\u3064\u30af\u30e9\u30b9\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final char PARAMETER_BEGIN = '(';
    private static final char PARAMETER_END = ')';
    private static final char PARAMETER_DELIMITER = ',';
    private String input;

    public StaticInvocationSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new TreeContentProvider());
        this.setSize(30, 18);
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
        this.setInput("");
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("\u30af\u30e9\u30b9");
        final Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setEditable(false);
        Button button = new Button(composite, 0);
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String expression = DialogUtil.openTypeSelectionDialog(StaticInvocationSelectionDialog.this.getShell());
                if (expression != null) {
                    text.setText(expression);
                    StaticInvocationSelectionDialog.this.changeType(expression);
                }
            }
        });
        return super.createTreeViewer(parent);
    }

    private void changeType(String expression) {
        this.input = expression;
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setInput((Object)expression);
        if (expression.length() > 0) {
            treeViewer.getTree().setEnabled(true);
        }
        treeViewer.refresh();
    }

    protected void updateOKStatus() {
        if (this.input != null && this.input.length() > 0) {
            this.updateStatus((IStatus)new Status(0, "org.eclipse.ui", 0, "", null));
        } else {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", 4, ERROR_INPUT, null));
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            return Resources.getImage("_icon_member");
        }

        public String getText(Object element) {
            StringBuilder stringBuilder = new StringBuilder();
            IMethod method = (IMethod)element;
            String methodName = method.getElementName();
            stringBuilder.append(methodName);
            stringBuilder.append('(');
            String[] paramSignatures = method.getParameterTypes();
            int paramLength = paramSignatures.length;
            int i = 0;
            while (i < paramLength) {
                String fqn = Signature.toString((String)paramSignatures[i]);
                stringBuilder.append(fqn.substring(fqn.lastIndexOf(46) + 1));
                if (i != paramLength - 1) {
                    stringBuilder.append(',');
                }
                ++i;
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    private static class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] methods = new IMethod[]{};
            String typeFqn = (String)inputElement;
            if (typeFqn.length() > 0) {
                methods = TypeUtil.findStaticMethods(typeFqn);
            }
            return methods;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

