/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.figure;

import jp.nimbus.ide.Resources;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class TiledImageFigure
extends ImageFigure {
    private static final int PADDING_LOGO = 8;
    private FigureCanvas parentCanvas;

    public TiledImageFigure(FigureCanvas parentCanvas, Image image) {
        super(image);
        this.parentCanvas = parentCanvas;
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle imageBounds = this.getImage().getBounds();
        org.eclipse.draw2d.geometry.Rectangle clientArea = this.getValidClientArea();
        int repeatX = clientArea.width / imageBounds.width + 1;
        int repeatY = clientArea.height / imageBounds.height + 1;
        int x = 0;
        while (x < repeatX) {
            int y = 0;
            while (y < repeatY) {
                graphics.drawImage(this.getImage(), clientArea.x + imageBounds.width * x, clientArea.y + imageBounds.height * y);
                ++y;
            }
            ++x;
        }
        Image logoImage = Resources.getImage("_image_logo");
        Rectangle logoImageBounds = logoImage.getBounds();
        graphics.drawImage(logoImage, clientArea.x + clientArea.width - logoImageBounds.width - 8, clientArea.y + clientArea.height - logoImageBounds.height - 8);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dimension;
        if (this.prefSize != null) {
            return this.prefSize;
        }
        if (this.getLayoutManager() != null && (dimension = this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint)) != null) {
            return dimension;
        }
        return this.getSize();
    }

    private org.eclipse.draw2d.geometry.Rectangle getValidClientArea() {
        Viewport viewport = this.parentCanvas.getViewport();
        org.eclipse.draw2d.geometry.Rectangle rectangle = viewport.getClientArea().getCopy();
        Point point = viewport.getViewLocation();
        rectangle.x = point.x;
        rectangle.y = point.y;
        return rectangle;
    }
}

