/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.model;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;

public class StorageModel {
    private IFile file;
    protected Document document;

    public StorageModel(FileEditorInput editorInput) {
        this.file = editorInput.getFile();
    }

    public void read() throws Exception {
        FileInputStream inputStream = new FileInputStream(this.getFilePath(this.file));
        this.read(inputStream);
    }

    public void read(InputStream inputStream) throws Exception {
        this.document = DocumentUtil.read(inputStream);
    }

    public void write() throws Exception {
        FileOutputStream outputStream = new FileOutputStream(this.getFilePath(this.file));
        DocumentUtil.write(outputStream, this.document);
    }

    public String getContentAsStirng() throws Exception {
        return DocumentUtil.convert(this.document);
    }

    protected void createErrorMarker(String message) throws CoreException {
        IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", 2);
    }

    private String getFilePath(IFile file) {
        return file.getLocation().toOSString();
    }
}

