/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.service.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.service.util.ServiceUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ServiceSelectionDialog
extends ElementTreeSelectionDialog {
    private static final int CHAR_WIDTH = 30;
    private static final int CHAR_HEIGHT = 18;
    private static final String TITLE = "\u30b5\u30fc\u30d3\u30b9\u306e\u9078\u629e";
    private static final String MESSAGE = "\u30b5\u30fc\u30d3\u30b9\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final String SERVICE_NAME_DELIMITER = "#";

    public ServiceSelectionDialog(Shell parent, String selectedServiceName) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new TreeContentProvider());
        this.setSize(30, 18);
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
        this.setInput(new Object());
    }

    protected void computeResult() {
        TreeElement element;
        TreeViewer treeViewer = this.getTreeViewer();
        TreeSelection selection = (TreeSelection)treeViewer.getSelection();
        if (selection != null && (element = (TreeElement)selection.getFirstElement()) != null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(String.valueOf(element.managerName) + SERVICE_NAME_DELIMITER + element.serviceName);
            this.setResult(result);
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            return Resources.getImage("_icon_member");
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof String) {
                text = (String)element;
            } else {
                TreeElement treeElement = (TreeElement)element;
                text = treeElement.serviceName;
            }
            return text;
        }
    }

    private static class TreeContentProvider
    implements ITreeContentProvider {
        private Map<String, List<String>> serviceNameMap;

        private TreeContentProvider() {
        }

        public Object[] getElements(Object input) {
            try {
                this.serviceNameMap = ServiceUtil.searchAllServiceNames();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            Object[] entries = null;
            if (this.serviceNameMap != null && this.serviceNameMap.size() > 0) {
                Set<String> keySet = this.serviceNameMap.keySet();
                entries = keySet.toArray(new String[keySet.size()]);
            }
            return entries;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            boolean result = false;
            if (element instanceof String) {
                result = this.serviceNameMap.containsKey(element);
            }
            return result;
        }

        public Object[] getChildren(Object parentElement) {
            List<String> values = this.serviceNameMap.get(parentElement);
            ArrayList<TreeElement> children = null;
            if (values != null) {
                children = new ArrayList<TreeElement>();
                for (String value : values) {
                    TreeElement element = new TreeElement((String)parentElement, value);
                    children.add(element);
                }
            }
            return children.toArray(new TreeElement[children.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class TreeElement {
        private String managerName;
        private String serviceName;

        public TreeElement(String managerName, String serviceName) {
            this.managerName = managerName;
            this.serviceName = serviceName;
        }
    }
}

