/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.service.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.nimbus.ide.Activator;
import jp.nimbus.ide.ProjectHandler;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtil {
    private static final String SERVICE_DEF_FILE_EXTENSION = "xml";
    private static final String SERVICE_DEF_ROOT_ELEMENT = "server";
    private static final String ATTR_NAME = "name";
    private static final String DEFAULT_MANAGER_NAME = "Nimbus";
    private static XPathExpression managerXPath;
    private static XPathExpression serviceNameXPath;

    static {
        try {
            managerXPath = Activator.xPath.compile("manager");
            serviceNameXPath = Activator.xPath.compile("service/@name");
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, List<String>> searchAllServiceNames() throws CoreException {
        TreeMap<String, List<String>> serviceNameMap = new TreeMap<String, List<String>>();
        IJavaProject javaProject = ProjectHandler.getCurrentProject();
        IResource[] resources = (IResource[])javaProject.getNonJavaResources();
        ServiceUtil.searchAllServiceNames(serviceNameMap, resources);
        return serviceNameMap;
    }

    private static void searchAllServiceNames(Map<String, List<String>> serviceNameMap, IResource[] resources) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String fileExtension = file.getFileExtension();
                if (SERVICE_DEF_FILE_EXTENSION.equals(fileExtension)) {
                    Element rootElement;
                    Document document = null;
                    try {
                        document = DocumentUtil.read(file.getContents());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (document != null && (rootElement = document.getDocumentElement()) != null && rootElement.getNodeName().equals(SERVICE_DEF_ROOT_ELEMENT)) {
                        NodeList nodeList = null;
                        try {
                            nodeList = (NodeList)managerXPath.evaluate(rootElement, XPathConstants.NODESET);
                        }
                        catch (XPathExpressionException e) {
                            e.printStackTrace();
                        }
                        if (nodeList != null) {
                            int nodeSize = nodeList.getLength();
                            int i = 0;
                            while (i < nodeSize) {
                                Element managerElement = (Element)nodeList.item(i);
                                String managerName = managerElement.getAttribute(ATTR_NAME);
                                if (managerName == null || managerName.length() == 0) {
                                    managerName = DEFAULT_MANAGER_NAME;
                                }
                                NodeList serviceNameNodeList = null;
                                try {
                                    serviceNameNodeList = (NodeList)serviceNameXPath.evaluate(managerElement, XPathConstants.NODESET);
                                }
                                catch (XPathExpressionException e) {
                                    e.printStackTrace();
                                }
                                if (serviceNameNodeList != null) {
                                    ArrayList<String> serviceNameList = new ArrayList<String>();
                                    int serviceNameNodeSize = serviceNameNodeList.getLength();
                                    int j = 0;
                                    while (j < serviceNameNodeSize) {
                                        String serviceName = serviceNameNodeList.item(j).getNodeValue();
                                        serviceNameList.add(serviceName);
                                        ++j;
                                    }
                                    Collections.sort(serviceNameList);
                                    serviceNameMap.put(managerName, serviceNameList);
                                }
                                ++i;
                            }
                        }
                    }
                }
            } else if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IResource[] innerResources = folder.members(false);
                ServiceUtil.searchAllServiceNames(serviceNameMap, innerResources);
            }
            ++n2;
        }
    }
}

