/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.util;

import jp.nimbus.ide.ProjectHandler;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectElementsManager<Result> {
    private static final String DEFINITION_FILE_EXTENSION = "xml";

    public Result search() throws CoreException {
        IJavaProject javaProject = ProjectHandler.getCurrentProject();
        IResource[] resources = (IResource[])javaProject.getNonJavaResources();
        this.search(resources);
        return this.getResult();
    }

    private void search(IResource[] resources) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (this.isCreatedResult()) break;
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String fileExtension = file.getFileExtension();
                if (DEFINITION_FILE_EXTENSION.equals(fileExtension)) {
                    Element rootElement;
                    Document document = null;
                    try {
                        document = DocumentUtil.read(file.getContents());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (document != null && (rootElement = document.getDocumentElement()) != null) {
                        this.searchDocument(rootElement);
                    }
                }
            } else if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IResource[] innerResources = folder.members(false);
                this.search(innerResources);
            }
            ++n2;
        }
    }

    protected abstract void searchDocument(Element var1);

    protected boolean isCreatedResult() {
        return false;
    }

    protected abstract Result getResult();
}

