/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jp.nimbus.ide.ProjectHandler;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    private static final String ROOT_TYPE_FQN = Object.class.getName();
    public static final String SETTER_PREFIX = "set";
    private static final char PARAMETER_BEGIN = '(';
    private static final char PARAMETER_END = ')';
    public static final String JDT_TYPE_INT = "I";
    public static final String JDT_TYPE_STRING = "QString;";

    public static IMethod[] findProperties(String typeFqn) {
        return TypeUtil.findMethods(typeFqn, MethodCategory.Property);
    }

    public static IMethod[] findMethods(String typeFqn) {
        return TypeUtil.findMethods(typeFqn, MethodCategory.Method);
    }

    public static IMethod[] findStaticMethods(String typeFqn) {
        return TypeUtil.findMethods(typeFqn, MethodCategory.StaticMethod);
    }

    private static IMethod[] findMethods(String typeFqn, MethodCategory category) {
        HashMap<String, IMethod> result = new HashMap<String, IMethod>();
        IJavaProject javaProject = ProjectHandler.getCurrentProject();
        try {
            TypeUtil.findMethods(result, javaProject, typeFqn, category);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        Collection collection = result.values();
        return collection.toArray(new IMethod[collection.size()]);
    }

    private static void findMethods(Map<String, IMethod> result, IJavaProject javaProject, String typeFqn, MethodCategory category) throws JavaModelException {
        IType type = javaProject.findType(typeFqn);
        if (type != null && type.isClass()) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                int flags = method.getFlags();
                if (Flags.isPublic((int)flags) && !Flags.isAbstract((int)flags)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(method.getElementName());
                    stringBuilder.append('(');
                    stringBuilder.append(method.getParameterTypes());
                    stringBuilder.append(')');
                    String methodName = stringBuilder.toString();
                    if (!result.containsKey(methodName)) {
                        if (category == MethodCategory.Property) {
                            String[] parameterTypes;
                            int parameterSize;
                            if (methodName.startsWith(SETTER_PREFIX) && ((parameterSize = (parameterTypes = method.getParameterTypes()).length) == 1 || parameterSize == 2 && (parameterTypes[0].equals(JDT_TYPE_INT) || parameterTypes[0].equals(JDT_TYPE_STRING)))) {
                                result.put(methodName, method);
                            }
                        } else if (category == MethodCategory.Method) {
                            if (!Flags.isStatic((int)flags)) {
                                result.put(methodName, method);
                            }
                        } else if (category == MethodCategory.StaticMethod && Flags.isStatic((int)flags)) {
                            result.put(methodName, method);
                        }
                    }
                }
                ++n2;
            }
            String superClassFqn = type.getSuperclassName();
            if (superClassFqn != null && !superClassFqn.equals(ROOT_TYPE_FQN)) {
                TypeUtil.findMethods(result, javaProject, superClassFqn, category);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MethodCategory {
        Property,
        Method,
        StaticMethod;

    }
}

