/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.widget;

import java.util.ArrayList;
import jp.nimbus.ide.widget.EditableTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MapViewer
extends EditableTableViewer {
    public MapViewer(Composite parent, String input) {
        super(parent, input);
        this.setupTable();
    }

    public String getOutput() {
        StringBuilder stringBuilder = new StringBuilder();
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            stringBuilder.append(tableItem.getData());
            stringBuilder.append("\n");
            ++n2;
        }
        int length = stringBuilder.length();
        stringBuilder.delete(length - "\n".length(), length);
        return stringBuilder.toString();
    }

    private void setupTable() {
        final Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("\u8ffd\u52a0"){

            public void run() {
                int newIndex = table.getItemCount();
                table.setItemCount(newIndex + 1);
                TableItem tableItem = table.getItem(newIndex);
                tableItem.setData((Object)new MapValue("", ""));
            }
        });
        menuManager.add((IAction)new Action("\u524a\u9664"){

            public void run() {
                table.remove(table.getSelectionIndex());
            }
        });
        table.setMenu(menuManager.createContextMenu((Control)table));
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText("\u30ad\u30fc");
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText("\u5024");
        column2.setWidth(200);
        this.setColumnProperties(new String[]{"_key", "_value"});
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
        this.setCellEditors(cellEditors);
        this.setCellModifier(new CellModifier(this));
        this.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.setContentProvider((IContentProvider)new TableContentProvider());
        this.setInput(this.input);
    }

    private class CellModifier
    implements ICellModifier {
        private TableViewer tableViewer;

        public CellModifier(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String value = null;
            MapValue mapValue = (MapValue)element;
            if (property.equals("_key")) {
                value = mapValue.key;
            } else if (property.equals("_value")) {
                value = mapValue.value;
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            MapValue mapValue = (MapValue)tableItem.getData();
            if (property.equals("_key")) {
                mapValue.key = value.toString();
            } else if (property.equals("_value")) {
                mapValue.value = value.toString();
            }
            this.tableViewer.update((Object)mapValue, null);
        }
    }

    private class MapValue {
        private static final String VALUE_DELIMITER = "=";
        private static final String FIELD_DELIMITER = "\n";
        private static final String KEY = "_key";
        private static final String VALUE = "_value";
        private String key;
        private String value;

        public MapValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.key) + VALUE_DELIMITER + this.value;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            String[] fields;
            ArrayList<MapValue> elementList = new ArrayList<MapValue>();
            String[] stringArray = fields = ((String)inputElement).trim().split("\n");
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                String[] values = field.trim().split("=");
                if (values.length == 2) {
                    elementList.add(new MapValue(values[0], values[1]));
                }
                ++n2;
            }
            return elementList.toArray(new MapValue[elementList.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            MapValue mapValue = (MapValue)element;
            return columnIndex == 0 ? mapValue.key : mapValue.value;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

