/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.nimbus.ide.xml.util.NimbusDtdResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DocumentUtil {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();

    static {
        transformerFactory.setAttribute("indent-number", 4);
    }

    public static Document read(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new NimbusDtdResolver());
            document = documentBuilder.parse(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return document;
    }

    public static void write(OutputStream outputStream, Document document) throws TransformerException, IOException {
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(domSource, streamResult);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static String convert(Document document) throws TransformerException, IOException {
        return DocumentUtil.convert(document, null);
    }

    public static String convert(Document document, String encoding) throws TransformerException, IOException {
        String result = null;
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("doctype-public", "-//Nimbus//DTD Nimbus Bean Flow 1.0//JA");
            transformer.setOutputProperty("doctype-system", "http://nimbus.sourceforge.jp/dtd/beanflow_1_0.dtd");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(domSource, streamResult);
            result = stringWriter.toString();
            result = result.replace("&#13;", "");
        }
        finally {
            if (stringWriter != null) {
                stringWriter.close();
            }
        }
        return result;
    }

    public static Document create() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public static Element createElement(Node node, String nodeName) {
        return node.getOwnerDocument().createElement(nodeName);
    }

    public static Element getFirstElement(Node node) {
        Element element = null;
        NodeList childNodes = node.getChildNodes();
        int childSize = childNodes.getLength();
        int i = 0;
        while (i < childSize) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                element = (Element)childNode;
                break;
            }
            ++i;
        }
        return element;
    }

    public static void removeFirstElement(Node node) {
        NodeList childNodes = node.getChildNodes();
        int childSize = childNodes.getLength();
        int i = 0;
        while (i < childSize) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                node.removeChild(childNode);
                break;
            }
            ++i;
        }
    }

    public static Text getFirstTextNode(Node node) {
        Text text = null;
        NodeList childNodes = node.getChildNodes();
        int childSize = childNodes.getLength();
        int i = 0;
        while (i < childSize) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 3) {
                text = (Text)childNode;
                break;
            }
            ++i;
        }
        return text;
    }

    public static void removeChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }
}

