/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.CompoundNFA;
import net.morilib.automata.nfa.NFAObject;

public final class CombinedNFA<T, A, B>
extends CompoundNFA<T, A, B> {
    final NFAState beginState = new NFAObject.IntStateObject(this, 0);

    private CombinedNFA() {
    }

    public static <T, A, B> CombinedNFA<T, A, B> newInstance(Collection<NFAObject<T, A, B>> col) {
        CombinedNFA<T, A, B> res = new CombinedNFA<T, A, B>();
        res.nfas = new ArrayList<NFAObject<T, A, B>>(col);
        return res;
    }

    public static <T, A, B> CombinedNFA<T, A, B> newInstance(NFAObject<T, A, B>[] arr) {
        CombinedNFA<T, A, B> res = new CombinedNFA<T, A, B>();
        res.nfas = Arrays.asList(arr);
        return res;
    }

    public static <T, A, B> CombinedNFA<T, A, B> newInstance(NFAObject<T, A, B> a, NFAObject<T, A, B> b) {
        CombinedNFA<T, A, B> res = new CombinedNFA<T, A, B>();
        res.nfas = new ArrayList();
        res.nfas.add(a);
        res.nfas.add(b);
        return res;
    }

    @Override
    void addInitialStates(Set<NFAState> res) {
        res.add(this.beginState);
    }

    @Override
    void addStatesEpsilon(Set<NFAState> res, NFAState state) {
        if (this.beginState.equals(state)) {
            int i = 0;
            while (i < this.nfas.size()) {
                ((NFAObject)this.nfas.get(i)).addInitialStates(res);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nfas.size()) {
                if (((NFAObject)this.nfas.get(i)).isState(state)) {
                    ((NFAObject)this.nfas.get(i)).addStatesEpsilon(res, state);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isState(NFAState o) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (((NFAObject)this.nfas.get(i)).isState(o)) {
                return true;
            }
            ++i;
        }
        return this.beginState.equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (((NFAObject)this.nfas.get(i)).isFinal(state)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isInitialState(NFAState state) {
        return this.beginState.equals(state);
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        HashSet<NFAState> res = new HashSet<NFAState>();
        int i = 0;
        while (i < this.nfas.size()) {
            res.addAll(((NFAObject)this.nfas.get(i)).getAcceptedStates());
            ++i;
        }
        return Collections.unmodifiableSet(res);
    }
}

