/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa.op;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.op.EpsilonEdge;
import net.morilib.automata.nfa.op.ResultConverter;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.IntervalMap;
import net.morilib.util.Tuple2;

public class MeetNFA<T, A, B, C, D>
implements NFA<T, C, D> {
    private final NFAEdges<T> eedg = new EpsilonEdge(null);
    private NFA<T, A, B> nfa1;
    private NFA<T, A, B> nfa2;
    private ResultConverter<A, C> convertA;
    private ResultConverter<B, D> convertB;

    static <T> Set<Tuple2<T, T>> directProduct(Set<T> a, Set<T> b) {
        HashSet<Tuple2<T, T>> r = new HashSet<Tuple2<T, T>>();
        for (T x : a) {
            for (T y : b) {
                r.add(new Tuple2<T, T>(x, y));
            }
        }
        return r;
    }

    static Set<NFAState> directProductState(Set<NFAState> a, Set<NFAState> b) {
        HashSet<NFAState> r = new HashSet<NFAState>();
        for (NFAState x : a) {
            for (NFAState y : b) {
                r.add(new PState(x, y));
            }
        }
        return r;
    }

    @Override
    public boolean isState(NFAState o) {
        return o instanceof PState;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, T alphabet) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return MeetNFA.directProductState(this.nfa1.getStates((NFAState)p.getA(), alphabet), this.nfa2.getStates((NFAState)p.getB(), alphabet));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return MeetNFA.directProductState(this.nfa1.getStates((NFAState)p.getA(), rng), this.nfa2.getStates((NFAState)p.getB(), rng));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return MeetNFA.directProductState(this.nfa1.getStates((NFAState)p.getA(), bound), this.nfa2.getStates((NFAState)p.getB(), bound));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return MeetNFA.directProductState(this.nfa1.getStatesEpsilon((NFAState)p.getA()), this.nfa2.getStatesEpsilon((NFAState)p.getB()));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return MeetNFA.directProductState(this.nfa1.getStatesBound((NFAState)p.getA(), bound), this.nfa2.getStatesBound((NFAState)p.getB(), bound));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return MeetNFA.directProductState(this.nfa1.getInitialStates(), this.nfa2.getInitialStates());
    }

    @Override
    public boolean isInitialState(NFAState state) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return this.nfa1.isInitialState((NFAState)p.getA()) && this.nfa2.isInitialState((NFAState)p.getB());
        }
        return false;
    }

    @Override
    public boolean isFinal(NFAState state) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return this.nfa1.isFinal((NFAState)p.getA()) && this.nfa2.isFinal((NFAState)p.getB());
        }
        return false;
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        for (NFAState s : states) {
            if (!this.isFinal(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<T> getEdges(NFAState state) {
        if (state instanceof PState) {
            PState p = (PState)state;
            final NFAEdges<T> g = this.nfa1.getEdges((NFAState)p.getA());
            final NFAEdges<T> h = this.nfa2.getEdges((NFAState)p.getB());
            return new NFAEdges<T>(){

                @Override
                public Set<NFAState> goNext(T alphabet) {
                    return MeetNFA.directProductState(g.goNext(alphabet), h.goNext(alphabet));
                }

                @Override
                public Set<NFAState> goNext(int alphabet) {
                    return MeetNFA.directProductState(g.goNext(alphabet), h.goNext(alphabet));
                }

                @Override
                public Set<NFAState> goNext(char alphabet) {
                    return MeetNFA.directProductState(g.goNext(alphabet), h.goNext(alphabet));
                }

                @Override
                public Set<NFAState> goNextEpsilon() {
                    return MeetNFA.directProductState(g.goNextEpsilon(), h.goNextEpsilon());
                }

                private void _p(IntervalMap<Void> m, Range r) {
                    for (Interval v : r.intervals()) {
                        m.put(v, null);
                    }
                }

                @Override
                public Set<? extends Range> nextAlphabets() {
                    IntervalMap<Void> m = new IntervalMap<Void>();
                    for (Range v : g.nextAlphabets()) {
                        this._p(m, v);
                    }
                    for (Range v : h.nextAlphabets()) {
                        this._p(m, v);
                    }
                    return m.keySet();
                }

                @Override
                public boolean isNextEpsilon() {
                    return !this.goNextEpsilon().isEmpty();
                }
            };
        }
        return this.eedg;
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        IntervalMap m = new IntervalMap();
        for (Interval v : this.nfa1.nextAlphabets(state)) {
            m.put(v, null);
        }
        for (Interval v : this.nfa2.nextAlphabets(state)) {
            m.put(v, null);
        }
        return m.keySet();
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        IntervalMap m = new IntervalMap();
        for (NFAState s : states) {
            for (Interval v : this.nextAlphabets(s)) {
                m.put(v, null);
            }
        }
        return m.keySet();
    }

    @Override
    public Set<T> nextDiscreteAlphabets(NFAState state) {
        HashSet<T> m = new HashSet<T>();
        m.addAll(this.nfa1.nextDiscreteAlphabets(state));
        m.addAll(this.nfa2.nextDiscreteAlphabets(state));
        return m;
    }

    @Override
    public Iterable<T> nextDiscreteAlphabets(Set<NFAState> states) {
        HashSet<T> m = new HashSet<T>();
        for (NFAState s : states) {
            m.addAll(this.nextDiscreteAlphabets(s));
        }
        return m;
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return MeetNFA.directProductState(this.nfa1.getAcceptedStates(), this.nfa2.getAcceptedStates());
    }

    @Override
    public Set<D> getMatchTag(NFAState state) {
        HashSet<D> r = new HashSet<D>();
        for (B x : this.nfa1.getMatchTag(state)) {
            for (B y : this.nfa2.getMatchTag(state)) {
                r.add(this.convertB.convert(x, y));
            }
        }
        return r;
    }

    @Override
    public Set<D> getMatchTagEnd(NFAState state) {
        HashSet<D> r = new HashSet<D>();
        for (B x : this.nfa1.getMatchTagEnd(state)) {
            for (B y : this.nfa2.getMatchTagEnd(state)) {
                r.add(this.convertB.convert(x, y));
            }
        }
        return r;
    }

    @Override
    public Set<C> getAccept(NFAState state) {
        HashSet<C> r = new HashSet<C>();
        for (A x : this.nfa1.getAccept(state)) {
            for (A y : this.nfa2.getAccept(state)) {
                r.add(this.convertA.convert(x, y));
            }
        }
        return r;
    }

    @Override
    public boolean isAccepted(NFAState state) {
        if (state instanceof PState) {
            PState p = (PState)state;
            return this.nfa1.isAccepted((NFAState)p.getA()) && this.nfa2.isAccepted((NFAState)p.getB());
        }
        return false;
    }

    private static class PState
    extends Tuple2<NFAState, NFAState>
    implements NFAState {
        public PState(NFAState a, NFAState b) {
            super(a, b);
        }
    }
}

