/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.expr;

import java.math.BigInteger;
import net.morilib.awk.nano.AwkArithmeticException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFloat;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkRemainderOp
extends AwkExpression {
    private AwkExpression e1;
    private AwkExpression e2;

    public AwkRemainderOp(AwkExpression e1, AwkExpression e2) {
        this.e1 = e1;
        this.e2 = e2;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue r1 = this.e1.eval(ns, o);
        AwkValue r2 = this.e2.eval(ns, o);
        if (r1 instanceof AwkUndefined) {
            return AwkInteger.ZERO;
        }
        if (r2 instanceof AwkUndefined) {
            throw new ArithmeticException();
        }
        if (r1.isIntegerValue() && r2.isIntegerValue()) {
            try {
                BigInteger e = r1.toInteger();
                BigInteger f = r2.toInteger();
                return AwkInteger.valueOf(e.remainder(f));
            }
            catch (ArithmeticException z) {
                throw new AwkArithmeticException(z.getMessage());
            }
        }
        if (r1.isFloat() || r2.isFloat()) {
            return AwkFloat.valueOf(Math.IEEEremainder(r1.toFloat(), r2.toFloat()));
        }
        return AwkFloat.valueOf(Math.IEEEremainder(r1.toFloat(), r2.toFloat()));
    }
}

