/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.statement;

import java.math.BigInteger;
import java.util.Collection;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.statement.AwkExecutable;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkValue;

public class AwkProgram
implements AwkExecutable {
    private AwkExecutable[] actions;

    public AwkProgram(Collection<AwkExecutable> actions) {
        this.actions = actions.toArray(new AwkExecutable[0]);
    }

    @Override
    public void execute(AwkNamespace ns, AwkFiles f, String s) {
        AwkValue v = ns.find("NR");
        BigInteger b = v != null ? v.toInteger() : BigInteger.ZERO;
        b = b.add(BigInteger.ONE);
        v = ns.find("FNR");
        b = v != null ? v.toInteger() : BigInteger.ZERO;
        b = b.add(BigInteger.ONE);
        AwkExecutable[] awkExecutableArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExecutable e = awkExecutableArray[n2];
            ns.setField(s);
            ns.assign("NR", AwkInteger.valueOf(b));
            ns.assign("FNR", AwkInteger.valueOf(b));
            e.execute(ns, f, s);
            ++n2;
        }
    }

    @Override
    public void executeBegin(AwkNamespace ns, AwkFiles f) {
        AwkExecutable[] awkExecutableArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExecutable e = awkExecutableArray[n2];
            e.executeBegin(ns, f);
            ++n2;
        }
    }

    @Override
    public void executeEnd(AwkNamespace ns, AwkFiles f) {
        AwkExecutable[] awkExecutableArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExecutable e = awkExecutableArray[n2];
            e.executeEnd(ns, f);
            ++n2;
        }
    }

    @Override
    public boolean isBegin() {
        AwkExecutable[] awkExecutableArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExecutable e = awkExecutableArray[n2];
            if (!e.isBegin()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isEnd() {
        AwkExecutable[] awkExecutableArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExecutable e = awkExecutableArray[n2];
            if (!e.isEnd()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isExecuteOnce() {
        AwkExecutable[] awkExecutableArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExecutable e = awkExecutableArray[n2];
            if (!e.isBegin()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

