/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.morilib.awk.nano.AwkRuntimeException;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkRegex
extends AwkValue {
    private Pattern regex;

    private AwkRegex(String regex) {
        this.regex = Pattern.compile(regex);
    }

    public static AwkRegex valueOf(String regex) {
        try {
            return new AwkRegex(regex);
        }
        catch (PatternSyntaxException e) {
            throw new AwkRuntimeException("invalid regex: " + regex);
        }
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isFloatValue() {
        return false;
    }

    @Override
    public boolean isIntegerValue() {
        return false;
    }

    @Override
    public boolean isRealValue() {
        return false;
    }

    @Override
    public boolean isNegativeValue() {
        return false;
    }

    @Override
    public boolean isPositiveValue() {
        return false;
    }

    @Override
    public boolean isZeroValue() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isRegex() {
        return true;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean toBoolean(AwkNamespace ns) {
        Matcher m = this.regex.matcher(ns.referField(0).toString());
        return m.find();
    }

    @Override
    public Pattern toRegex(AwkNamespace ns) {
        if (ns.isIgnoreCase()) {
            String s = this.regex.pattern();
            return Pattern.compile(s, 2);
        }
        return this.regex;
    }

    @Override
    public Object toObject() {
        return this.regex;
    }

    @Override
    public int compareTo(AwkValue o, AwkNamespace ns) {
        if (o instanceof AwkUndefined) {
            return 1;
        }
        if (ns.isIgnoreCase()) {
            return this.toString(ns).compareToIgnoreCase(o.toString(ns));
        }
        return this.toString(ns).compareTo(o.toString(ns));
    }

    @Override
    public String toString(AwkNamespace ns) {
        return this.regex.pattern();
    }
}

