/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.nano.Closure;
import net.morilib.lisp.nano.ClosureClass;
import net.morilib.lisp.nano.Datum;

class CompiledCode {
    private List<Code> opers = new ArrayList<Code>();
    private List<Integer> labels = new ArrayList<Integer>();

    CompiledCode() {
    }

    Code getCode(int addr) {
        return addr < this.opers.size() ? this.opers.get(addr) : null;
    }

    int getAddress(int label) {
        return this.labels.get(label);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.opers.size()) {
            Code c = this.opers.get(i);
            if (c.datum instanceof ClosureClass) {
                buf.append("----------------------------\n");
                buf.append(((ClosureClass)c.datum).getCode());
                buf.append("----------------------------\n");
            } else if (c.datum instanceof Closure) {
                buf.append("----------------------------\n");
                buf.append(((Closure)c.datum).getCode());
                buf.append("----------------------------\n");
            }
            buf.append(c.toString());
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    static class Builder {
        private CompiledCode codes = new CompiledCode();

        Builder() {
        }

        void addPush(Datum d) {
            Code c = new Code(Oper.PUSH);
            c.datum = d;
            this.codes.opers.add(c);
        }

        void addPop() {
            this.codes.opers.add(new Code(Oper.POP));
        }

        void addBeginList() {
            this.codes.opers.add(new Code(Oper.BEGIN_LIST));
        }

        void addAppendList() {
            this.codes.opers.add(new Code(Oper.APPEND_LIST));
        }

        void addAppendListSplicing() {
            this.codes.opers.add(new Code(Oper.APPEND_LIST_SPLICING));
        }

        void addAppendListMultiValues() {
            this.codes.opers.add(new Code(Oper.APPEND_LIST_MULTI_VALUES));
        }

        void addEndListDot() {
            this.codes.opers.add(new Code(Oper.END_LIST_DOT));
        }

        void addEndList() {
            this.codes.opers.add(new Code(Oper.END_LIST));
        }

        void addEndListVector() {
            this.codes.opers.add(new Code(Oper.END_LIST_VECTOR));
        }

        void addCall() {
            this.codes.opers.add(new Code(Oper.CALL));
        }

        void addCallMethod() {
            this.codes.opers.add(new Code(Oper.CALL_METHOD));
        }

        void addCallTail(int rewind) {
            Code c = new Code(Oper.CALL_TAIL);
            c.rewind = rewind;
            this.codes.opers.add(c);
        }

        void addJmp(int jmpLabel) {
            Code c = new Code(Oper.JMP);
            c.jmpLabel = jmpLabel;
            this.codes.opers.add(c);
        }

        void addJmpIf(int jmpLabel) {
            Code c = new Code(Oper.JMP_IF);
            c.jmpLabel = jmpLabel;
            this.codes.opers.add(c);
        }

        void addJmpUnless(int jmpLabel) {
            Code c = new Code(Oper.JMP_UNLESS);
            c.jmpLabel = jmpLabel;
            this.codes.opers.add(c);
        }

        void addJmpTop() {
            this.codes.opers.add(new Code(Oper.JMP_TOP));
        }

        void addReferSymbol(Datum destSymbol) {
            Code c = new Code(Oper.REFER_SYMBOL);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addReferSetter(Datum destSymbol) {
            Code c = new Code(Oper.REFER_SETTER);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addDefined(Datum destSymbol) {
            Code c = new Code(Oper.REFER_DEFINED);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addBind(Datum destSymbol) {
            Code c = new Code(Oper.BIND);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addSet(Datum destSymbol) {
            Code c = new Code(Oper.SET);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addReturnOp() {
            this.codes.opers.add(new Code(Oper.RETURN_OP));
        }

        void addPushContinuation() {
            Code c = new Code(Oper.PUSH_CONTINUATION);
            this.codes.opers.add(c);
        }

        void addForce() {
            this.codes.opers.add(new Code(Oper.FORCE));
        }

        void addNewPromise(Datum p) {
            Code c = new Code(Oper.NEW_PROMISE);
            c.datum = p;
            this.codes.opers.add(c);
        }

        void addAppendValues() {
            this.codes.opers.add(new Code(Oper.APPEND_VALUES));
        }

        void addEvalCode() {
            this.codes.opers.add(new Code(Oper.EVAL_CODE));
        }

        void addOverrideLoadCode() {
            this.codes.opers.add(new Code(Oper.OVERRIDE_LOAD_CODE));
        }

        int getCurrentAddress() {
            return this.codes.opers.size();
        }

        void setCurrentAddressToLabel(int label) {
            this.codes.labels.set(label, this.getCurrentAddress());
        }

        int allocLabel() {
            int res = this.codes.labels.size();
            this.codes.labels.add(-1);
            return res;
        }

        CompiledCode getCodeRef() {
            return this.codes;
        }

        void merge(CompiledCode cc) {
            this.codes.opers.addAll(cc.opers);
            this.codes.labels.addAll(cc.labels);
        }
    }

    static class Code {
        private Oper op;
        private Datum datum;
        private int jmpLabel;
        private int rewind;

        private Code(Oper op) {
            this.op = op;
        }

        Oper getOp() {
            return this.op;
        }

        Datum getDatum() {
            return this.datum;
        }

        int getJmpLabel() {
            return this.jmpLabel;
        }

        int getRewind() {
            return this.rewind;
        }

        public String toString() {
            return (Object)((Object)this.op) + ":" + this.datum + ":" + this.jmpLabel;
        }
    }

    static enum Oper {
        PUSH,
        POP,
        BEGIN_LIST,
        APPEND_LIST,
        APPEND_LIST_SPLICING,
        APPEND_LIST_MULTI_VALUES,
        END_LIST_DOT,
        END_LIST,
        END_LIST_VECTOR,
        CALL,
        CALL_TAIL,
        CALL_METHOD,
        JMP,
        JMP_IF,
        JMP_UNLESS,
        JMP_TOP,
        REFER_SYMBOL,
        REFER_SETTER,
        REFER_DEFINED,
        BIND,
        BIND_MACRO,
        BIND_MACRO_QUOTE,
        SET,
        RETURN_OP,
        PUSH_CONTINUATION,
        FORCE,
        NEW_PROMISE,
        APPEND_VALUES,
        EVAL_CODE,
        OVERRIDE_LOAD_CODE;

    }
}

