/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispRational;
import net.morilib.lisp.nano.LispReal;
import net.morilib.lisp.nano.LispSmallInt;
import net.morilib.lisp.nano.LispString;

public final class LispBigInt
extends LispInteger
implements Serializable {
    private static final long serialVersionUID = 3485888605431065348L;
    private BigInteger value;

    LispBigInt(BigInteger value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispInteger) {
            return LispInteger.valueOf(this.value.add(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getDenominator();
            BigInteger nn = this.value.multiply(r.getDenominator()).add(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        return super.add(x);
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispInteger) {
            return LispRational.newRational(this.value, x.getBigInteger());
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getNumerator();
            BigInteger nn = this.value.multiply(r.getDenominator());
            return LispRational.newRational(nn, nd);
        }
        return super.div(x);
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispInteger) {
            return LispInteger.valueOf(this.value.multiply(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getDenominator();
            BigInteger nn = this.value.multiply(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        return super.mul(x);
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispInteger) {
            return LispInteger.valueOf(this.value.subtract(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getDenominator();
            BigInteger nn = this.value.multiply(r.getDenominator()).subtract(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        return super.sub(x);
    }

    @Override
    public LispInteger uminus() {
        return new LispBigInt(this.value.negate());
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispSmallInt) {
            return false;
        }
        if (x instanceof LispBigInt) {
            return this.value.equals(x.getBigInteger());
        }
        if (x instanceof LispRational) {
            return false;
        }
        if (x instanceof LispDouble) {
            return this.value.doubleValue() == ((LispDouble)x).doubleValue();
        }
        return false;
    }

    @Override
    public boolean isLessThan(LispReal x) {
        if (x instanceof LispInteger) {
            return this.value.compareTo(x.getBigInteger()) < 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger n1 = this.value.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) < 0;
        }
        if (x instanceof LispDouble) {
            return this.value.doubleValue() < x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        if (x instanceof LispInteger) {
            return this.value.compareTo(x.getBigInteger()) > 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger n1 = this.value.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) > 0;
        }
        if (x instanceof LispDouble) {
            return this.value.doubleValue() > x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public LispReal toInexact() {
        return new LispDouble(this.value.doubleValue());
    }

    @Override
    public String toDisplay() {
        return this.value.toString();
    }

    @Override
    public String toWrite() {
        return this.value.toString();
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        return new LispString(this.value.toString(radix));
    }

    @Override
    public boolean isOne() {
        return this.value.equals(BigInteger.ONE);
    }

    @Override
    public BigInteger getBigInteger() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value.intValue();
    }

    @Override
    public long getLong() {
        return this.value.longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public double getRealDouble() {
        return this.value.doubleValue();
    }

    @Override
    public LispReal remainder(LispReal r) {
        if (!r.isExact()) {
            return new LispDouble(Math.IEEEremainder(this.value.doubleValue(), r.getRealDouble()));
        }
        if (r instanceof LispInteger) {
            BigInteger n = this.value.remainder(r.getBigInteger());
            return LispInteger.valueOf(n);
        }
        if (r instanceof LispRational) {
            BigInteger d = r.getDenominator();
            BigInteger n = this.value.remainder(r.getNumerator());
            return LispRational.newRational(n, d);
        }
        return new LispDouble(Math.IEEEremainder(this.value.doubleValue(), r.getRealDouble()));
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof LispBigInt) {
            return this.value.equals(((LispBigInt)x).value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int l = 17;
        l = 37 * l + this.value.hashCode();
        return l;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public LispReal angle() {
        return this.value.signum() >= 0 ? LispInteger.ZERO : new LispDouble(Math.PI);
    }
}

