/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import net.morilib.lisp.nano.LispComplex;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispExactReal;
import net.morilib.lisp.nano.LispInteger;

public abstract class LispReal
extends LispComplex
implements Comparable<LispReal> {
    @Override
    public LispReal getReal() {
        return this;
    }

    @Override
    public double getImagDouble() {
        return 0.0;
    }

    @Override
    public LispReal getImag() {
        if (this.isNaN()) {
            return LispDouble.NaN;
        }
        if (this.isExact()) {
            return LispInteger.ZERO;
        }
        return LispDouble.ZERO;
    }

    @Override
    public int compareTo(LispReal o) {
        return this.isLessThan(o) ? -1 : (this.isMoreThan(o) ? 1 : 0);
    }

    public abstract boolean isLessThan(LispReal var1);

    public abstract boolean isMoreThan(LispReal var1);

    public abstract int signum();

    @Override
    public abstract LispExactReal toExact();

    @Override
    public abstract LispReal toInexact();

    public abstract boolean isInfinity();

    public LispReal abs() {
        return this.signum() >= 0 ? this : this.uminus();
    }

    @Override
    public abstract boolean isNaN();

    @Override
    public abstract boolean isOne();

    @Override
    public abstract LispReal uminus();

    @Override
    public abstract String toWrite();

    @Override
    public LispReal norm() {
        return this.signum() < 0 ? this.uminus() : this;
    }

    @Override
    public LispReal conjugate() {
        return this;
    }

    public abstract LispReal floor();

    public abstract LispReal ceil();

    public abstract LispReal remainder(LispReal var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

