/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Undef;

public class MultiValues
extends Datum {
    private List<? extends Datum> values;

    private MultiValues(List<? extends Datum> values) {
        if (values == null) {
            throw new NullPointerException();
        }
        this.values = values;
    }

    public static Datum newValues(List<? extends Datum> values) {
        if (values.size() == 0) {
            return Undef.UNDEF;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return new MultiValues(values);
    }

    public static Datum newValues(Datum ... values) {
        if (values.length == 0) {
            return Undef.UNDEF;
        }
        if (values.length == 1) {
            return values[0];
        }
        return new MultiValues(Arrays.asList(values));
    }

    @Override
    public boolean isTrue() {
        return this.values.isEmpty() || this.values.get(0).isTrue();
    }

    @Override
    public List<Datum> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public int howManyValues() {
        return this.values.size();
    }

    public Datum getValueOf(int x) {
        if (x >= 0 && x < this.values.size()) {
            return this.values.get(x);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public String toDisplay() {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (Datum datum : this.values) {
            b.append(LispUtils.toDisplay(datum));
            b.append(d);
            d = "\n";
        }
        return b.toString();
    }

    @Override
    public String toWrite() {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (Datum datum : this.values) {
            b.append(LispUtils.toWrite(datum));
            b.append(d);
            d = "\n";
        }
        return b.toString();
    }
}

