/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.nano.ClosureClass;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispCompiler;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.SymbolName;
import net.morilib.lisp.nano.Syntax;
import net.morilib.lisp.nano.SyntaxUtils;
import net.morilib.lisp.nano.Undef;

public class SynDefine
extends Syntax {
    private void defun(Datum bcar, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist, boolean toplevel, CodeExecutor exec, IntStack memento) {
        Cons c = (Cons)bcar;
        CompiledCode.Builder mbuild = new CompiledCode.Builder();
        Environment menv = new Environment(env);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(menv);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, c, true, mesg, new ArrayList<Cons>(), exec, memento);
        nbuild.addReturnOp();
        ClosureClass cln = new ClosureClass(c.getCdr(), nbuild.getCodeRef());
        mbuild.addPush(cln);
        mbuild.addReturnOp();
        ClosureClass clm = new ClosureClass(Nil.NIL, mbuild.getCodeRef());
        build.addPush(clm);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addBind(c.getCar());
        build.addPush(Undef.UNDEF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        if (!(body instanceof Cons)) throw mesg.getError("err.define.malform");
        Datum bcar = ((Cons)body).getCar();
        Datum bcdr = ((Cons)body).getCdr();
        if (bcar instanceof Cons) {
            Datum cz = ((Cons)bcar).getCar();
            if (!(cz instanceof SymbolName)) {
                throw mesg.getError("err.define.malform");
            }
            this.defun(bcar, bcdr, env, comp, build, callsym, mesg, symlist, toplevel, exec, memento);
            return;
        } else {
            if (!(bcar instanceof SymbolName)) throw mesg.getError("err.define.malform");
            SyntaxUtils.compileBind(bcar, bcdr, env, comp, build, callsym, toplevel, mesg, "err.define.malform", new ArrayList<Cons>(), exec, memento);
        }
    }
}

