/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.nano.ClosureClass;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispCompiler;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.Syntax;
import net.morilib.lisp.nano.SyntaxUtils;

public class SynLambda
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        Datum bcdr;
        Cons c;
        if (body instanceof Cons) {
            c = (Cons)body;
            bcdr = c.getCdr();
            if (!SyntaxUtils.isValidSymbolList(c.getCar())) {
                throw mesg.getError("err.parameters", c.getCar());
            }
        } else {
            throw mesg.getError("err.lambda.malform");
        }
        CompiledCode.Builder mbuild = new CompiledCode.Builder();
        Environment menv = new Environment(env);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(menv);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, new Cons(), true, mesg, new ArrayList<Cons>(), exec, memento);
        nbuild.addReturnOp();
        ClosureClass cln = new ClosureClass(c.getCar(), nbuild.getCodeRef());
        mbuild.addPush(cln);
        mbuild.addReturnOp();
        ClosureClass clm = new ClosureClass(Nil.NIL, mbuild.getCodeRef());
        build.addPush(clm);
        build.addBeginList();
        build.addEndList();
        build.addCall();
    }
}

